/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbi.transaction.spring;

import io.micronaut.configuration.jdbi.transaction.AbstractTransactionHandler;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jdbi.v3.core.Handle;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Requires(classes={PlatformTransactionManager.class})
@EachBean(value=PlatformTransactionManager.class)
public class SpringTransactionHandler
extends AbstractTransactionHandler {
    private final ConcurrentHashMap<Handle, LocalStuff> localStuff = new ConcurrentHashMap();
    private final PlatformTransactionManager transactionManager;

    public SpringTransactionHandler(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin(Handle handle) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(6);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        this.localStuff.putIfAbsent(handle, new LocalStuff(status));
    }

    public void commit(Handle handle) {
        this.withLocalStuff(handle, localStuff -> {
            try {
                this.transactionManager.commit(localStuff.getTransactionStatus());
            }
            finally {
                this.restore(handle);
            }
        });
    }

    public void rollback(Handle handle) {
        this.didTxnRollback.set(true);
        this.withLocalStuff(handle, localStuff -> {
            try {
                this.transactionManager.rollback(localStuff.getTransactionStatus());
            }
            finally {
                this.restore(handle);
            }
        });
    }

    public boolean isInTransaction(Handle handle) {
        TransactionStatus status = this.getTransactionStatus(handle);
        return status != null && !status.isCompleted();
    }

    public void savepoint(Handle handle, String savepointName) {
        this.withLocalStuff(handle, localStuff -> {
            Object savePoint = localStuff.getTransactionStatus().createSavepoint();
            localStuff.getSavepoints().put(savepointName, savePoint);
        });
    }

    public void rollbackToSavepoint(Handle handle, String savepointName) {
        this.withLocalStuff(handle, localStuff -> {
            Object savePoint = localStuff.getSavepoints().get(savepointName);
            if (savePoint != null) {
                localStuff.getTransactionStatus().rollbackToSavepoint(savePoint);
            }
        });
    }

    public void releaseSavepoint(Handle handle, String savepointName) {
        this.withLocalStuff(handle, localStuff -> {
            Object savePoint = localStuff.getSavepoints().remove(savepointName);
            if (savePoint != null) {
                localStuff.getTransactionStatus().releaseSavepoint(savePoint);
            }
        });
    }

    private TransactionStatus getTransactionStatus(Handle handle) {
        LocalStuff localStuff = this.localStuff.get(handle);
        return localStuff != null ? localStuff.getTransactionStatus() : null;
    }

    private void withLocalStuff(Handle handle, Consumer<LocalStuff> consumer) {
        LocalStuff localStuff = this.localStuff.get(handle);
        if (localStuff != null) {
            consumer.accept(localStuff);
        }
    }

    private void restore(Handle handle) {
        try {
            LocalStuff stuff = this.localStuff.remove(handle);
            if (stuff != null) {
                stuff.getSavepoints().clear();
            }
        }
        finally {
            this.localStuff.remove(handle);
        }
    }

    private static class LocalStuff {
        private final Map<String, Object> savepoints = new HashMap<String, Object>();
        private final TransactionStatus transactionStatus;

        LocalStuff(TransactionStatus transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        Map<String, Object> getSavepoints() {
            return this.savepoints;
        }

        TransactionStatus getTransactionStatus() {
            return this.transactionStatus;
        }
    }
}

