/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbi.transaction.micronaut;

import io.micronaut.configuration.jdbi.transaction.AbstractTransactionHandler;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.jdbc.DataSourceTransactionManager;
import io.micronaut.transaction.support.DefaultTransactionDefinition;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jdbi.v3.core.Handle;

@Requires(classes={DataSourceTransactionManager.class})
@EachBean(value=DataSourceTransactionManager.class)
public class MicronautDataTransactionHandler
extends AbstractTransactionHandler {
    private final ConcurrentHashMap<Handle, LocalStuff> localTransactions = new ConcurrentHashMap();
    private final DataSourceTransactionManager transactionManager;

    public MicronautDataTransactionHandler(DataSourceTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin(Handle handle) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(TransactionDefinition.Propagation.NESTED);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        this.localTransactions.putIfAbsent(handle, new LocalStuff((TransactionStatus<Connection>)status));
    }

    public void commit(Handle handle) {
        this.withLocalStuff(handle, localStuff -> {
            try {
                this.transactionManager.commit(localStuff.getTransactionStatus());
            }
            finally {
                this.restore(handle);
            }
        });
    }

    public void rollback(Handle handle) {
        this.didTxnRollback.set(true);
        this.withLocalStuff(handle, localStuff -> {
            try {
                this.transactionManager.rollback(localStuff.getTransactionStatus());
            }
            finally {
                this.restore(handle);
            }
        });
    }

    public boolean isInTransaction(Handle handle) {
        TransactionStatus<Connection> status = this.getTransactionStatus(handle);
        return status != null && !status.isCompleted();
    }

    public void savepoint(Handle handle, String savepointName) {
    }

    public void rollbackToSavepoint(Handle handle, String savepointName) {
    }

    public void releaseSavepoint(Handle handle, String savepointName) {
    }

    private TransactionStatus<Connection> getTransactionStatus(Handle handle) {
        LocalStuff localStuff = this.localTransactions.get(handle);
        return localStuff != null ? localStuff.getTransactionStatus() : null;
    }

    private void withLocalStuff(Handle handle, Consumer<LocalStuff> consumer) {
        LocalStuff localStuff = this.localTransactions.get(handle);
        if (localStuff != null) {
            consumer.accept(localStuff);
        }
    }

    private void restore(Handle handle) {
        try {
            LocalStuff stuff = this.localTransactions.remove(handle);
            if (stuff != null) {
                stuff.getSavepoints().clear();
            }
        }
        finally {
            this.localTransactions.remove(handle);
        }
    }

    private static class LocalStuff {
        private final Map<String, Object> savepoints = new HashMap<String, Object>();
        private final TransactionStatus<Connection> transactionStatus;

        LocalStuff(TransactionStatus<Connection> transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        Map<String, Object> getSavepoints() {
            return this.savepoints;
        }

        TransactionStatus<Connection> getTransactionStatus() {
            return this.transactionStatus;
        }
    }
}

