/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import org.jooq.Converter;
import org.jooq.ConverterProvider;
import org.jooq.JSON;
import org.jooq.JSONB;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.DefaultConverterProvider;

@Singleton
@Requires(beans={ObjectMapper.class})
@Bean(typed={JacksonConverterProvider.class})
@Deprecated
public class JacksonConverterProvider
implements ConverterProvider {
    private final ConverterProvider delegate = new DefaultConverterProvider();
    private final ObjectMapper objectMapper;

    public JacksonConverterProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Nullable
    public <T, U> Converter<T, U> provide(Class<T> tType, Class<U> uType) {
        if (tType == JSON.class) {
            return Converter.ofNullable(tType, uType, t -> {
                try {
                    return this.objectMapper.readValue(((JSON)t).data(), uType);
                }
                catch (Exception e) {
                    throw new DataTypeException("JSON mapping error", (Throwable)e);
                }
            }, u -> {
                try {
                    return JSON.valueOf((String)this.objectMapper.writeValueAsString(u));
                }
                catch (Exception e) {
                    throw new DataTypeException("JSON mapping error", (Throwable)e);
                }
            });
        }
        if (tType == JSONB.class) {
            return Converter.ofNullable(tType, uType, t -> {
                try {
                    return this.objectMapper.readValue(((JSONB)t).data(), uType);
                }
                catch (Exception e) {
                    throw new DataTypeException("JSON mapping error", (Throwable)e);
                }
            }, u -> {
                try {
                    return JSONB.valueOf((String)this.objectMapper.writeValueAsString(u));
                }
                catch (Exception e) {
                    throw new DataTypeException("JSON mapping error", (Throwable)e);
                }
            });
        }
        return this.delegate.provide(tType, uType);
    }
}

