/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq;

import io.micronaut.context.annotation.EachProperty;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jooq.SQLDialect;
import org.jooq.tools.jdbc.JDBCUtils;

@EachProperty(value="jooq.datasources")
public class JooqConfigurationProperties {
    private SQLDialect sqlDialect;
    private boolean jacksonConverterEnabled = false;
    private boolean jsonConverterEnabled = false;

    public SQLDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public void setSqlDialect(SQLDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    @Deprecated
    public boolean isJacksonConverterEnabled() {
        return this.jacksonConverterEnabled;
    }

    @Deprecated
    public void setJacksonConverterEnabled(boolean jacksonConverterEnabled) {
        this.jacksonConverterEnabled = jacksonConverterEnabled;
    }

    public boolean isJsonConverterEnabled() {
        return this.jsonConverterEnabled;
    }

    public void setJsonConverterEnabled(boolean jsonConverterEnabled) {
        this.jsonConverterEnabled = jsonConverterEnabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLDialect determineSqlDialect(DataSource dataSource) {
        if (this.sqlDialect != null) {
            return this.sqlDialect;
        }
        if (dataSource == null) {
            return SQLDialect.DEFAULT;
        }
        try (Connection connection = dataSource.getConnection();){
            SQLDialect sQLDialect = JDBCUtils.dialect((Connection)connection);
            return sQLDialect;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

