/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonMapper;
import jakarta.inject.Singleton;
import java.nio.charset.StandardCharsets;
import org.jooq.Converter;
import org.jooq.ConverterProvider;
import org.jooq.JSON;
import org.jooq.JSONB;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.DefaultConverterProvider;

@Singleton
@Requires(beans={JsonMapper.class})
public class JsonConverterProvider
implements ConverterProvider {
    private final ConverterProvider delegate = new DefaultConverterProvider();
    private final JsonMapper jsonMapper;

    public JsonConverterProvider(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Nullable
    public <T, U> Converter<T, U> provide(Class<T> tType, Class<U> uType) {
        if (tType == JSON.class) {
            return Converter.ofNullable(tType, uType, t -> {
                try {
                    return this.jsonMapper.readValue(((JSON)t).data(), Argument.of((Class)uType));
                }
                catch (Exception e) {
                    throw new DataTypeException("JSON mapping error", (Throwable)e);
                }
            }, u -> {
                try {
                    return JSON.valueOf((String)new String(this.jsonMapper.writeValueAsBytes(u), StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    throw new DataTypeException("JSON mapping error", (Throwable)e);
                }
            });
        }
        if (tType == JSONB.class) {
            return Converter.ofNullable(tType, uType, t -> {
                try {
                    return this.jsonMapper.readValue(((JSONB)t).data(), Argument.of((Class)uType));
                }
                catch (Exception e) {
                    throw new DataTypeException("JSON mapping error", (Throwable)e);
                }
            }, u -> {
                try {
                    return JSONB.valueOf((String)new String(this.jsonMapper.writeValueAsBytes(u), StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    throw new DataTypeException("JSON mapping error", (Throwable)e);
                }
            });
        }
        return this.delegate.provide(tType, uType);
    }
}

