/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq;

import io.micronaut.configuration.jooq.MicronautTransaction;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.jdbc.DataSourceTransactionManager;
import java.sql.Connection;
import org.jooq.Transaction;
import org.jooq.TransactionContext;
import org.jooq.TransactionProvider;
import org.jooq.exception.DataAccessException;

@Requires(classes={DataSourceTransactionManager.class})
@EachBean(value=DataSourceTransactionManager.class)
public class MicronautTransactionProvider
implements TransactionProvider {
    private final DataSourceTransactionManager transactionManager;

    public MicronautTransactionProvider(DataSourceTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin(TransactionContext context) throws DataAccessException {
        TransactionDefinition definition = TransactionDefinition.DEFAULT;
        TransactionStatus status = this.transactionManager.getTransaction(definition);
        context.transaction((Transaction)new MicronautTransaction((TransactionStatus<Connection>)status));
    }

    public void commit(TransactionContext ctx) throws DataAccessException {
        this.transactionManager.commit(this.getTransactionStatus(ctx));
    }

    public void rollback(TransactionContext ctx) throws DataAccessException {
        this.transactionManager.rollback(this.getTransactionStatus(ctx));
    }

    private TransactionStatus<Connection> getTransactionStatus(TransactionContext ctx) {
        MicronautTransaction transaction = (MicronautTransaction)ctx.transaction();
        return transaction.getTxStatus();
    }
}

