/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq;

import io.micronaut.configuration.jooq.AbstractJooqConfigurationProperties;
import io.micronaut.configuration.jooq.JsonConverterProvider;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.qualifiers.Qualifiers;
import org.jooq.ConverterProvider;
import org.jooq.DiagnosticsListenerProvider;
import org.jooq.ExecuteListenerProvider;
import org.jooq.ExecutorProvider;
import org.jooq.MetaProvider;
import org.jooq.RecordListenerProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordUnmapperProvider;
import org.jooq.TransactionListenerProvider;
import org.jooq.TransactionProvider;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DefaultConfiguration;

public class AbstractJooqConfigurationFactory {
    protected DefaultConfiguration jooqConfiguration(@Parameter String name, @Parameter @Nullable TransactionProvider transactionProvider, @Parameter @Nullable Settings settings, @Parameter @Nullable ExecutorProvider executorProvider, @Parameter @Nullable RecordMapperProvider recordMapperProvider, @Parameter @Nullable RecordUnmapperProvider recordUnmapperProvider, @Parameter @Nullable MetaProvider metaProvider, @Parameter @Nullable ConverterProvider converterProvider, AbstractJooqConfigurationProperties properties, ApplicationContext ctx) {
        DefaultConfiguration configuration = new DefaultConfiguration();
        if (transactionProvider != null) {
            configuration.setTransactionProvider(transactionProvider);
        }
        if (settings != null) {
            configuration.setSettings(settings);
        }
        if (executorProvider != null) {
            configuration.setExecutorProvider(executorProvider);
        }
        if (recordMapperProvider != null) {
            configuration.setRecordMapperProvider(recordMapperProvider);
        }
        if (recordUnmapperProvider != null) {
            configuration.setRecordUnmapperProvider(recordUnmapperProvider);
        }
        if (metaProvider != null) {
            configuration.setMetaProvider(metaProvider);
        }
        if (converterProvider != null) {
            configuration.set(converterProvider);
        } else if (properties.isJsonConverterEnabled()) {
            ctx.findBean(JsonConverterProvider.class).ifPresent(arg_0 -> ((DefaultConfiguration)configuration).set(arg_0));
        }
        configuration.setExecuteListenerProvider(ctx.getBeansOfType(ExecuteListenerProvider.class, Qualifiers.byName((String)name)).toArray(new ExecuteListenerProvider[0]));
        configuration.setRecordListenerProvider(ctx.getBeansOfType(RecordListenerProvider.class, Qualifiers.byName((String)name)).toArray(new RecordListenerProvider[0]));
        configuration.setVisitListenerProvider(ctx.getBeansOfType(VisitListenerProvider.class, Qualifiers.byName((String)name)).toArray(new VisitListenerProvider[0]));
        configuration.setTransactionListenerProvider(ctx.getBeansOfType(TransactionListenerProvider.class, Qualifiers.byName((String)name)).toArray(new TransactionListenerProvider[0]));
        configuration.setDiagnosticsListenerProvider(ctx.getBeansOfType(DiagnosticsListenerProvider.class, Qualifiers.byName((String)name)).toArray(new DiagnosticsListenerProvider[0]));
        return configuration;
    }
}

