/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq;

import io.micronaut.configuration.jooq.AbstractJooqConfigurationFactory;
import io.micronaut.configuration.jooq.JooqConfigurationProperties;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.jdbc.DataSourceResolver;
import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.ConverterProvider;
import org.jooq.ExecutorProvider;
import org.jooq.MetaProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordUnmapperProvider;
import org.jooq.TransactionProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DefaultConfiguration;

@Factory
@Internal
final class JooqConfigurationFactory
extends AbstractJooqConfigurationFactory {
    JooqConfigurationFactory() {
    }

    @EachBean(value=DataSource.class)
    Configuration jooqConfiguration(@Parameter String name, DataSource dataSource, @Parameter @Nullable TransactionProvider transactionProvider, @Parameter @Nullable Settings settings, @Parameter @Nullable ExecutorProvider executorProvider, @Parameter @Nullable RecordMapperProvider recordMapperProvider, @Parameter @Nullable RecordUnmapperProvider recordUnmapperProvider, @Parameter @Nullable MetaProvider metaProvider, @Parameter @Nullable ConverterProvider converterProvider, @Parameter @Nullable ConnectionProvider connectionProvider, @Parameter @Nullable JooqConfigurationProperties properties, @Nullable DataSourceResolver dataSourceResolver, @Nullable ApplicationContext ctx) {
        if (properties == null) {
            properties = new JooqConfigurationProperties();
        }
        if (dataSourceResolver == null) {
            dataSourceResolver = DataSourceResolver.DEFAULT;
        }
        DefaultConfiguration configuration = super.jooqConfiguration(name, transactionProvider, settings, executorProvider, recordMapperProvider, recordUnmapperProvider, metaProvider, converterProvider, properties, ctx);
        if (connectionProvider != null) {
            configuration.setConnectionProvider(connectionProvider);
        }
        configuration.setSQLDialect(properties.determineSqlDialect(dataSourceResolver.resolve(dataSource)));
        if (transactionProvider != null) {
            configuration.setTransactionProvider(transactionProvider);
        }
        if (connectionProvider == null) {
            configuration.setDataSource(dataSource);
        }
        return configuration;
    }
}

