/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq;

import io.micronaut.configuration.jooq.AbstractJooqConfigurationFactory;
import io.micronaut.configuration.jooq.R2dbcJooqConfigurationProperties;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.r2dbc.spi.ConnectionFactory;
import org.jooq.Configuration;
import org.jooq.ConverterProvider;
import org.jooq.ExecutorProvider;
import org.jooq.MetaProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordUnmapperProvider;
import org.jooq.SQLDialect;
import org.jooq.TransactionProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DefaultConfiguration;

@Requires(classes={ConnectionFactory.class})
@Internal
@Factory
final class R2dbcJooqConfigurationFactory
extends AbstractJooqConfigurationFactory {
    R2dbcJooqConfigurationFactory() {
    }

    @EachBean(value=ConnectionFactory.class)
    Configuration jooqConfiguration(@Parameter String name, ConnectionFactory connectionFactory, @Parameter @Nullable TransactionProvider transactionProvider, @Parameter @Nullable Settings settings, @Parameter @Nullable ExecutorProvider executorProvider, @Parameter @Nullable RecordMapperProvider recordMapperProvider, @Parameter @Nullable RecordUnmapperProvider recordUnmapperProvider, @Parameter @Nullable MetaProvider metaProvider, @Parameter @Nullable ConverterProvider converterProvider, @Parameter @Nullable R2dbcJooqConfigurationProperties properties, ApplicationContext ctx) {
        if (properties == null) {
            properties = new R2dbcJooqConfigurationProperties();
        }
        DefaultConfiguration configuration = super.jooqConfiguration(name, transactionProvider, settings, executorProvider, recordMapperProvider, recordUnmapperProvider, metaProvider, converterProvider, properties, ctx);
        configuration.setSQLDialect(this.getSqlDialect(properties));
        configuration.setConnectionFactory(connectionFactory);
        return configuration;
    }

    private SQLDialect getSqlDialect(R2dbcJooqConfigurationProperties properties) {
        SQLDialect sqlDialect = properties.getSqlDialect();
        if (sqlDialect == null) {
            sqlDialect = SQLDialect.DEFAULT;
        }
        return sqlDialect;
    }
}

