/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.vertx.pg.client;

import io.micronaut.configuration.vertx.pg.client.PgClientConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.vertx.core.Vertx;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.spi.PgDriver;
import io.vertx.sqlclient.Pool;
import jakarta.inject.Singleton;
import java.util.Collections;

@Factory
class PgDriverFactory {
    private final PgClientConfiguration connectionConfiguration;
    private final Vertx vertx;

    PgDriverFactory(PgClientConfiguration connectionConfiguration, @Nullable Vertx vertx) {
        this.connectionConfiguration = connectionConfiguration;
        this.vertx = vertx;
    }

    @Singleton
    @Bean(preDestroy="close")
    Pool build() {
        String connectionUri = this.connectionConfiguration.getUri();
        if (StringUtils.isNotEmpty((CharSequence)connectionUri)) {
            PgConnectOptions pgConnectOptions = PgDriver.INSTANCE.parseConnectionUri(connectionUri);
            return PgDriver.INSTANCE.createPool(this.vertx, Collections.singletonList(pgConnectOptions), this.connectionConfiguration.poolOptions);
        }
        return PgDriver.INSTANCE.createPool(this.vertx, Collections.singletonList(this.connectionConfiguration.connectOptions), this.connectionConfiguration.poolOptions);
    }
}

