/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.vertx.pg.client;

import io.micronaut.configuration.vertx.pg.client.PgClientConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.pgclient.PgPool;
import io.vertx.sqlclient.PoolOptions;
import jakarta.inject.Singleton;

@Factory
public class PgClientFactory {
    private final PgClientConfiguration connectionConfiguration;
    private final Vertx vertx;

    public PgClientFactory(PgClientConfiguration connectionConfiguration, @Nullable Vertx vertx) {
        this.connectionConfiguration = connectionConfiguration;
        this.vertx = vertx;
    }

    @Singleton
    @Bean(preDestroy="close")
    public PgPool client() {
        if (this.vertx == null) {
            return this.createClient();
        }
        return this.createClient(this.vertx);
    }

    private PgPool createClient() {
        PgClientConfiguration configuration = this.connectionConfiguration;
        String connectionUri = configuration.getUri();
        if (StringUtils.isNotEmpty((CharSequence)connectionUri)) {
            return PgPool.pool((String)connectionUri, (PoolOptions)configuration.poolOptions);
        }
        return PgPool.pool((PgConnectOptions)configuration.connectOptions, (PoolOptions)configuration.poolOptions);
    }

    private PgPool createClient(Vertx vertx) {
        PgClientConfiguration configuration = this.connectionConfiguration;
        String connectionUri = configuration.getUri();
        if (StringUtils.isNotEmpty((CharSequence)connectionUri)) {
            return PgPool.pool((Vertx)vertx, (String)connectionUri, (PoolOptions)configuration.poolOptions);
        }
        return PgPool.pool((Vertx)vertx, (PgConnectOptions)configuration.connectOptions, (PoolOptions)configuration.poolOptions);
    }
}

