/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.vertx.pg.client.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.vertx.reactivex.pgclient.PgPool;
import io.vertx.reactivex.sqlclient.Row;
import jakarta.inject.Singleton;
import java.util.Collections;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(property="endpoints.health.vertx.pg.client.enabled", notEquals="false")})
@Singleton
public class PgHealthIndicator
implements HealthIndicator {
    public static final String NAME = "vertx-pg-client";
    public static final String QUERY = "SELECT version();";
    private final PgPool client;

    public PgHealthIndicator(PgPool client) {
        this.client = client;
    }

    public Publisher<HealthResult> getResult() {
        return this.client.query(QUERY).rxExecute().map(rows -> {
            HealthResult.Builder status = HealthResult.builder((String)NAME, (HealthStatus)HealthStatus.UP);
            Row row = (Row)rows.iterator().next();
            status.details(Collections.singletonMap("version", row.getString(0)));
            return status.build();
        }).onErrorReturn(this::buildErrorResult).toFlowable();
    }

    private HealthResult buildErrorResult(Throwable throwable) {
        return HealthResult.builder((String)NAME, (HealthStatus)HealthStatus.DOWN).exception(throwable).build();
    }
}

