/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.MessageSource;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.starter.api.FeatureDTO;
import io.micronaut.starter.api.FeatureOperations;
import io.micronaut.starter.application.ApplicationType;
import io.micronaut.starter.feature.AvailableFeatures;
import io.micronaut.starter.feature.Feature;
import jakarta.inject.Singleton;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@Singleton
public class FeatureService
implements FeatureOperations {
    private final List<Feature> features;
    private final BeanLocator beanLocator;
    private final MessageSource messageSource;

    public FeatureService(List<Feature> features, BeanLocator beanLocator, MessageSource messageSource) {
        this.features = features;
        this.beanLocator = beanLocator;
        this.messageSource = messageSource;
    }

    @Override
    public List<FeatureDTO> getAllFeatures(Locale locale) {
        MessageSource.MessageContext context = MessageSource.MessageContext.of((Locale)locale);
        return this.features.stream().filter(Feature::isVisible).map(feature -> new FeatureDTO((Feature)feature, this.messageSource, context)).sorted(Comparator.comparing(FeatureDTO::getName)).collect(Collectors.toList());
    }

    @Override
    public List<FeatureDTO> getFeatures(Locale locale, ApplicationType type) {
        MessageSource.MessageContext context = MessageSource.MessageContext.of((Locale)locale);
        return ((AvailableFeatures)this.beanLocator.getBean(AvailableFeatures.class, Qualifiers.byName((String)type.getName()))).getFeatures().map(feature -> new FeatureDTO((Feature)feature, this.messageSource, context)).sorted(Comparator.comparing(FeatureDTO::getName)).collect(Collectors.toList());
    }
}

