/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.starter.api.ApplicationTypeDTO;
import io.micronaut.starter.api.BuildToolDTO;
import io.micronaut.starter.api.JdkVersionDTO;
import io.micronaut.starter.api.LanguageDTO;
import io.micronaut.starter.api.TestFrameworkDTO;
import io.micronaut.starter.api.options.ApplicationTypeSelectOptions;
import io.micronaut.starter.api.options.BuildToolSelectOptions;
import io.micronaut.starter.api.options.JdkVersionSelectOptions;
import io.micronaut.starter.api.options.LanguageSelectOptions;
import io.micronaut.starter.api.options.TestFrameworkSelectOptions;
import io.micronaut.starter.application.ApplicationType;
import io.micronaut.starter.options.BuildTool;
import io.micronaut.starter.options.JdkVersion;
import io.micronaut.starter.options.Language;
import io.micronaut.starter.options.TestFramework;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Schema(name="SelectOptions")
@Introspected
public class SelectOptionsDTO {
    private ApplicationTypeSelectOptions type;
    private JdkVersionSelectOptions jdkVersion;
    private LanguageSelectOptions lang;
    private TestFrameworkSelectOptions test;
    private BuildToolSelectOptions build;

    SelectOptionsDTO() {
    }

    @Creator
    public SelectOptionsDTO(ApplicationTypeSelectOptions type, JdkVersionSelectOptions jdkVersion, LanguageSelectOptions lang, TestFrameworkSelectOptions test, BuildToolSelectOptions build) {
        this.type = type;
        this.jdkVersion = jdkVersion;
        this.lang = lang;
        this.test = test;
        this.build = build;
    }

    @Schema(description="supported options for application type")
    public ApplicationTypeSelectOptions getType() {
        return this.type;
    }

    @Schema(description="supported options for jdk versions")
    public JdkVersionSelectOptions getJdkVersion() {
        return this.jdkVersion;
    }

    @Schema(description="supported options for code languages")
    public LanguageSelectOptions getLang() {
        return this.lang;
    }

    @Schema(description="supported options for test frameworks")
    public TestFrameworkSelectOptions getTest() {
        return this.test;
    }

    @Schema(description="supported options for build tools")
    public BuildToolSelectOptions getBuild() {
        return this.build;
    }

    public static SelectOptionsDTO make(MessageSource messageSource, MessageSource.MessageContext messageContext) {
        List<ApplicationTypeDTO> applications = Arrays.stream(ApplicationType.values()).map(it -> new ApplicationTypeDTO((ApplicationType)it, null, messageSource, messageContext)).collect(Collectors.toList());
        ApplicationTypeSelectOptions applicationOpts = new ApplicationTypeSelectOptions(applications, new ApplicationTypeDTO(ApplicationType.DEFAULT_OPTION, null, messageSource, messageContext));
        List<JdkVersionDTO> jdkVersions = Arrays.stream(JdkVersion.values()).map(it -> new JdkVersionDTO((JdkVersion)it, messageSource, messageContext)).collect(Collectors.toList());
        JdkVersionSelectOptions jdkVersionOpts = new JdkVersionSelectOptions(jdkVersions, new JdkVersionDTO(JdkVersion.DEFAULT_OPTION, messageSource, messageContext));
        List<LanguageDTO> languages = Arrays.stream(Language.values()).map(it -> new LanguageDTO((Language)it, messageSource, messageContext)).collect(Collectors.toList());
        LanguageSelectOptions languageOpts = new LanguageSelectOptions(languages, new LanguageDTO(Language.DEFAULT_OPTION, messageSource, messageContext));
        List<TestFrameworkDTO> testFrameworks = Arrays.stream(TestFramework.values()).map(it -> new TestFrameworkDTO((TestFramework)it, messageSource, messageContext)).collect(Collectors.toList());
        TestFrameworkSelectOptions testFrameworkOpts = new TestFrameworkSelectOptions(testFrameworks, new TestFrameworkDTO(TestFramework.DEFAULT_OPTION, messageSource, messageContext));
        List<BuildToolDTO> buildTools = Arrays.stream(BuildTool.values()).map(it -> new BuildToolDTO((BuildTool)it, messageSource, messageContext)).collect(Collectors.toList());
        BuildToolSelectOptions buildToolOpts = new BuildToolSelectOptions(buildTools, new BuildToolDTO(BuildTool.DEFAULT_OPTION, messageSource, messageContext));
        return new SelectOptionsDTO(applicationOpts, jdkVersionOpts, languageOpts, testFrameworkOpts, buildToolOpts);
    }
}

