/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.starter.api.RequestInfo;
import io.micronaut.starter.api.StarterConfiguration;
import jakarta.inject.Singleton;
import java.util.Locale;
import java.util.Optional;

@Singleton
public class RequestInfoArgumentBinder
implements TypedRequestArgumentBinder<RequestInfo> {
    private static final Argument<RequestInfo> TYPE = Argument.of(RequestInfo.class);
    private final StarterConfiguration configuration;

    public RequestInfoArgumentBinder(StarterConfiguration configuration) {
        this.configuration = configuration;
    }

    public Argument<RequestInfo> argumentType() {
        return TYPE;
    }

    public ArgumentBinder.BindingResult<RequestInfo> bind(ArgumentConversionContext<RequestInfo> context, HttpRequest<?> source) {
        String url = this.resolveUrl(source);
        return () -> Optional.of(new RequestInfo(url, source.getPath(), source.getParameters(), source.getLocale().orElse(Locale.ENGLISH), (String)source.getHeaders().get((CharSequence)"User-Agent")));
    }

    private String resolveUrl(HttpRequest<?> request) {
        String cp = this.configuration.getPath().orElse("");
        String url = this.configuration.getUrl().map(Object::toString).orElse(null);
        if (url != null) {
            if (url.startsWith("https://")) {
                return url + cp;
            }
            return "https://" + url + cp;
        }
        String hostname = request.getUri().getHost();
        String host = hostname != null ? hostname : "localhost";
        int port = request.getServerAddress().getPort();
        if (port > -1 && port != 80) {
            host = host + ":" + port;
        }
        url = (request.isSecure() ? "https" : "http") + "://" + host + cp;
        return url;
    }
}

