/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api.create;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.starter.api.TestFramework;
import io.micronaut.starter.api.UserAgentParser;
import io.micronaut.starter.api.event.ApplicationGeneratingEvent;
import io.micronaut.starter.application.ApplicationType;
import io.micronaut.starter.application.OperatingSystem;
import io.micronaut.starter.application.Project;
import io.micronaut.starter.application.generator.GeneratorContext;
import io.micronaut.starter.application.generator.ProjectGenerator;
import io.micronaut.starter.io.ConsoleOutput;
import io.micronaut.starter.options.BuildTool;
import io.micronaut.starter.options.JdkVersion;
import io.micronaut.starter.options.Language;
import io.micronaut.starter.options.Options;
import io.micronaut.starter.util.NameUtils;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCreateController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCreateController.class);
    protected final ProjectGenerator projectGenerator;
    private final ApplicationEventPublisher eventPublisher;

    protected AbstractCreateController(ProjectGenerator projectGenerator, ApplicationEventPublisher eventPublisher) {
        this.projectGenerator = projectGenerator;
        this.eventPublisher = eventPublisher;
    }

    public GeneratorContext createProjectGeneratorContext(ApplicationType type, @Pattern(regexp="[\\w\\d-_\\.]+") @Pattern(regexp="[\\w\\d-_\\.]+") String name, @Nullable List<String> features, @Nullable BuildTool buildTool, @Nullable TestFramework testFramework, @Nullable Language lang, @Nullable JdkVersion javaVersion, @Nullable @Header(value="User-Agent") String userAgent) {
        GeneratorContext generatorContext;
        Project project;
        try {
            project = NameUtils.parse((String)name);
        }
        catch (IllegalArgumentException e) {
            throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Invalid project name: " + e.getMessage());
        }
        try {
            Language language = lang != null ? lang : Language.DEFAULT_OPTION;
            generatorContext = this.projectGenerator.createGeneratorContext(type, project, new Options(lang, testFramework != null ? testFramework.toTestFramework() : language.getDefaults().getTest(), buildTool == null ? language.getDefaults().getBuild() : buildTool, javaVersion == null ? JdkVersion.DEFAULT_OPTION : javaVersion), this.getOperatingSystem(userAgent), features != null ? features : Collections.emptyList(), ConsoleOutput.NOOP);
            try {
                this.eventPublisher.publishEvent((Object)new ApplicationGeneratingEvent(generatorContext));
            }
            catch (Exception e) {
                LOG.warn("Error firing application generated event: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            throw new HttpStatusException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
        return generatorContext;
    }

    protected OperatingSystem getOperatingSystem(String userAgent) {
        return UserAgentParser.getOperatingSystem(userAgent);
    }
}

