/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api.create.github;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.scheduling.annotation.ExecuteOn;
import io.micronaut.starter.api.RequestInfo;
import io.micronaut.starter.api.TestFramework;
import io.micronaut.starter.api.create.github.GitHubCreateDTO;
import io.micronaut.starter.api.create.github.GitHubCreateOperation;
import io.micronaut.starter.api.create.github.GitHubCreateService;
import io.micronaut.starter.api.create.github.GitHubRedirectService;
import io.micronaut.starter.application.ApplicationType;
import io.micronaut.starter.client.github.v3.GitHubRepository;
import io.micronaut.starter.options.BuildTool;
import io.micronaut.starter.options.JdkVersion;
import io.micronaut.starter.options.Language;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@ExecuteOn(value="io")
@Requires(beans={GitHubCreateService.class, GitHubRedirectService.class})
public class GitHubCreateController
implements GitHubCreateOperation {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubCreateController.class);
    private final GitHubCreateService gitHubCreateService;
    private final GitHubRedirectService redirectService;

    public GitHubCreateController(GitHubCreateService gitHubCreateService, GitHubRedirectService redirectService) {
        this.gitHubCreateService = gitHubCreateService;
        this.redirectService = redirectService;
    }

    @Override
    @Get(uri="/github/{type}/{name}{?features,lang,build,test,javaVersion,code,state}", produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Created GitHub repository containing the generated application. In case the configuration contains launcher URI the redirect to launcher is sent.", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="307", description="Redirects to GitHub OAuth API to obtain user authorisation code before creating the GitHub repository."), @ApiResponse(responseCode="307", description="Redirects back to launcher in case of successfully created GitHub repository.")})
    public HttpResponse<GitHubCreateDTO> createApp(@NonNull ApplicationType type, @Pattern(regexp="[\\w\\d-_\\.]+") @Pattern(regexp="[\\w\\d-_\\.]+") String name, @Nullable List<String> features, @Nullable BuildTool build, @Nullable TestFramework test, @Nullable Language lang, @Nullable JdkVersion javaVersion, @Nullable String code, @Nullable String state, @Nullable @Header(value="User-Agent") String userAgent, @Parameter(hidden=true) @NonNull RequestInfo requestInfo) {
        URI launcherURI = this.redirectService.getLauncherURI();
        try {
            if (StringUtils.isEmpty((CharSequence)code) || StringUtils.isEmpty((CharSequence)state)) {
                return HttpResponse.temporaryRedirect((URI)this.redirectService.constructOAuthRedirectUrl(requestInfo));
            }
            GitHubRepository repository = this.gitHubCreateService.creatApp(type, name, features, build, test, lang, javaVersion, code, state, userAgent);
            if (launcherURI == null) {
                return HttpResponse.ok((Object)new GitHubCreateDTO(repository.getUrl(), repository.getCloneUrl(), repository.getHtmlUrl()));
            }
            return HttpResponse.temporaryRedirect((URI)this.redirectService.constructLauncherRedirectUrl(repository));
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage());
            }
            if (launcherURI == null) {
                throw e;
            }
            return HttpResponse.temporaryRedirect((URI)this.redirectService.constructLauncherErrorRedirectUrl(e.getMessage()));
        }
    }

    @Get(uri="/github{?error,error_description}", produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="307", description="Forwarded GitHub OAuth error message."), @ApiResponse(responseCode="200", description="Returns GitHub OAuth application callback error.")})
    public HttpResponse<String> handleCallback(@Nullable String error, @Nullable @QueryValue(value="error_description") String errorDescription) {
        URI redirect = !StringUtils.isEmpty((CharSequence)error) ? this.redirectService.constructLauncherErrorRedirectUrl(errorDescription) : this.redirectService.getLauncherURI();
        if (redirect == null) {
            return HttpResponse.ok((Object)errorDescription);
        }
        return HttpResponse.temporaryRedirect((URI)redirect);
    }
}

