/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api.create.github;

import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.starter.api.RequestInfo;
import io.micronaut.starter.api.StarterConfiguration;
import io.micronaut.starter.client.github.v3.GitHubRepository;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="micronaut.http.services.github-oauth.url")
public class GitHubRedirectService {
    public static final String OAUTH_URL = "micronaut.http.services.github-oauth.url";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubRedirectService.class);
    private static final String AUTHORIZE_PATH = "/login/oauth/authorize";
    private final String githubOAuthUrl;
    private final StarterConfiguration starterConfiguration;
    private final StarterConfiguration.GitHubConfiguration gitHubConfiguration;

    public GitHubRedirectService(@NotNull @Property(name="micronaut.http.services.github-oauth.url") String githubOAuthUrl, @NotNull StarterConfiguration starterConfiguration, @NotNull StarterConfiguration.GitHubConfiguration gitHubConfiguration) {
        this.githubOAuthUrl = githubOAuthUrl + AUTHORIZE_PATH;
        this.starterConfiguration = starterConfiguration;
        this.gitHubConfiguration = gitHubConfiguration;
    }

    protected URI constructOAuthRedirectUrl(RequestInfo requestInfo) {
        try {
            UriBuilder uriBuilder = UriBuilder.of((CharSequence)requestInfo.getServerURL()).path(requestInfo.getPath());
            requestInfo.getParameters().forEachValue((x$0, xva$1) -> uriBuilder.queryParam(x$0, new Object[]{xva$1}));
            URI redirectUri = uriBuilder.build();
            return UriBuilder.of((CharSequence)this.githubOAuthUrl).queryParam("scope", new Object[]{this.gitHubConfiguration.getTokenPermissions()}).queryParam("client_id", new Object[]{this.gitHubConfiguration.getClientId()}).queryParam("redirect_uri", new Object[]{redirectUri.toString()}).queryParam("state", new Object[]{UUID.randomUUID().toString()}).build();
        }
        catch (Exception e) {
            String msg = "Failed to construct redirect URI using request " + requestInfo + " to GiHub OAuth: " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    protected URI constructLauncherRedirectUrl(GitHubRepository gitHubRepository) {
        URI redirectUri = this.getLauncherURI();
        if (redirectUri == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Can't construct redirect back to launcher as configuration is missing redirect uri.");
            }
            return null;
        }
        try {
            return UriBuilder.of((URI)redirectUri).queryParam("url", new Object[]{gitHubRepository.getUrl()}).queryParam("cloneUrl", new Object[]{gitHubRepository.getCloneUrl()}).queryParam("htmlUrl", new Object[]{gitHubRepository.getHtmlUrl()}).build();
        }
        catch (Exception e) {
            String msg = "Failed to construct redirect to URI back to launcher: " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    protected URI constructLauncherErrorRedirectUrl(String error) {
        URI redirectUri = this.getLauncherURI();
        if (redirectUri == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Can't construct redirect back to launcher as configuration is missing redirect uri.");
            }
            return null;
        }
        try {
            return UriBuilder.of((URI)redirectUri).queryParam("error", new Object[]{error}).build();
        }
        catch (Exception e) {
            String msg = "Failed to construct error redirect to URI back to launcher: " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    protected URI getLauncherURI() {
        return this.starterConfiguration.getRedirectUri().orElse(null);
    }
}

