/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Described;
import io.micronaut.core.naming.Named;
import io.micronaut.starter.api.FeatureDTO;
import io.micronaut.starter.api.Linkable;
import io.micronaut.starter.api.Selectable;
import io.micronaut.starter.application.ApplicationType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(name="ApplicationTypeInfo")
@Introspected
public class ApplicationTypeDTO
extends Linkable
implements Named,
Described,
Selectable<ApplicationType> {
    static final String MESSAGE_PREFIX = "micronaut.starter.application-types.";
    private final String name;
    private final List<FeatureDTO> features;
    private final String title;
    private final String description;
    private final ApplicationType value;

    public ApplicationTypeDTO(ApplicationType type, List<FeatureDTO> features) {
        this.value = type;
        this.name = type.getName();
        this.features = features;
        this.title = type.getTitle();
        this.description = type.getDescription();
    }

    @Creator
    @Internal
    ApplicationTypeDTO(ApplicationType value, String name, String title, String description, List<FeatureDTO> features) {
        this.value = value;
        this.name = name;
        this.features = features;
        this.title = title;
        this.description = description;
    }

    @Internal
    ApplicationTypeDTO(ApplicationType type, List<FeatureDTO> features, MessageSource messageSource, MessageSource.MessageContext messageContext) {
        String name;
        this.value = type;
        this.name = name = type.getName();
        this.features = features;
        this.title = messageSource.getMessage(MESSAGE_PREFIX + name + ".title", messageContext, type.getTitle());
        this.description = messageSource.getMessage(MESSAGE_PREFIX + name + ".description", messageContext, type.getDescription());
    }

    @Schema(description="The title of the application type")
    public String getTitle() {
        return this.title;
    }

    @Schema(description="The possible application features")
    public List<FeatureDTO> getFeatures() {
        return this.features;
    }

    @Override
    @Schema(description="A description of the application type")
    public String getDescription() {
        return this.description;
    }

    @Schema(description="The name of the application type")
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(description="The value of the application type for select options")
    public ApplicationType getValue() {
        return this.value;
    }

    @Override
    @Schema(description="The label of the application type for select options")
    public String getLabel() {
        return this.description.replaceFirst("A ", "").trim();
    }
}

