/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Described;
import io.micronaut.core.naming.Named;
import io.micronaut.starter.api.Linkable;
import io.micronaut.starter.api.Selectable;
import io.micronaut.starter.options.JdkVersion;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(name="JdkVersionInfo")
@Introspected
public class JdkVersionDTO
extends Linkable
implements Named,
Described,
Selectable<JdkVersion> {
    static final String MESSAGE_PREFIX = "micronaut.starter.jdkVersion.";
    private final JdkVersion value;
    private final String name;
    private final String description;
    private final Integer majorVersion;

    public JdkVersionDTO(JdkVersion jdkVersion) {
        this.value = jdkVersion;
        this.name = jdkVersion.toString();
        this.description = String.valueOf(jdkVersion.majorVersion());
        this.majorVersion = jdkVersion.majorVersion();
    }

    @Creator
    @Internal
    JdkVersionDTO(String name, String description, Integer majorVersion, JdkVersion value) {
        this.value = value;
        this.name = name;
        this.description = description;
        this.majorVersion = majorVersion;
    }

    @Internal
    JdkVersionDTO(JdkVersion jdkVersion, MessageSource messageSource, MessageSource.MessageContext messageContext) {
        String name = jdkVersion.name();
        this.value = jdkVersion;
        this.name = name;
        this.description = messageSource.getMessage(MESSAGE_PREFIX + name + ".description", messageContext, name);
        this.majorVersion = jdkVersion.majorVersion();
    }

    @Override
    @Schema(description="A description of the jdkVersion")
    public String getDescription() {
        return this.description;
    }

    @Schema(description="The name of the jdkVersion")
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(description="The value of the jdkVersion for select options")
    @NonNull
    public JdkVersion getValue() {
        return this.value;
    }

    @Override
    @Schema(description="The label of the jdkVersion for select options")
    public String getLabel() {
        return this.description.replaceFirst("JDK_", "");
    }
}

