/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;

@ConfigurationProperties(value="micronaut.starter")
public class StarterConfiguration {
    public static final String PREFIX = "micronaut.starter";
    private URL url;
    private String path;
    private URI redirectUri = URI.create("https://micronaut.io/launch");

    public StarterConfiguration() {
        String hostname = System.getenv("HOSTNAME");
        if (hostname != null) {
            try {
                this.url = new URL("https://" + hostname);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public Optional<URI> getRedirectUri() {
        return Optional.ofNullable(this.redirectUri);
    }

    public void setRedirectUri(@Nullable URI redirectUri) {
        this.redirectUri = redirectUri;
    }

    public Optional<URL> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    public void setPath(String path) {
        this.path = path;
    }

    @ConfigurationProperties(value="github")
    public static class GitHubConfiguration {
        public static final String PREFIX = "github";
        private String clientId;
        private String clientSecret;
        private String tokenPermissions;

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getTokenPermissions() {
            return this.tokenPermissions;
        }

        public void setTokenPermissions(String tokenPermissions) {
            this.tokenPermissions = tokenPermissions;
        }
    }
}

