/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api.create.github;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.starter.api.StarterConfiguration;
import io.micronaut.starter.api.TestFramework;
import io.micronaut.starter.api.create.AbstractCreateController;
import io.micronaut.starter.application.ApplicationType;
import io.micronaut.starter.application.generator.GeneratorContext;
import io.micronaut.starter.application.generator.ProjectGenerator;
import io.micronaut.starter.client.github.oauth.AccessToken;
import io.micronaut.starter.client.github.oauth.GitHubOAuthClient;
import io.micronaut.starter.client.github.v3.GitHubApiClient;
import io.micronaut.starter.client.github.v3.GitHubRepository;
import io.micronaut.starter.client.github.v3.GitHubUser;
import io.micronaut.starter.io.ConsoleOutput;
import io.micronaut.starter.io.FileSystemOutputHandler;
import io.micronaut.starter.io.OutputHandler;
import io.micronaut.starter.options.BuildTool;
import io.micronaut.starter.options.JdkVersion;
import io.micronaut.starter.options.Language;
import io.micronaut.starter.util.GitHubUtil;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(beans={GitHubOAuthClient.class})
public class GitHubCreateService
extends AbstractCreateController {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubCreateService.class);
    private static final String TOKEN_PREFIX = "token ";
    private static final String REPO_PREFIX = "generated";
    private static final String TMP_DIR = "/tmp";
    private final GitHubOAuthClient gitHubOAuthClient;
    private final GitHubApiClient gitHubApiClient;
    private final StarterConfiguration.GitHubConfiguration gitHubConfiguration;

    public GitHubCreateService(@NotNull ProjectGenerator projectGenerator, @NotNull ApplicationEventPublisher eventPublisher, @NotNull GitHubOAuthClient gitHubOAuthClient, @NotNull GitHubApiClient gitHubApiClient, @NotNull StarterConfiguration.GitHubConfiguration gitHubConfiguration) {
        super(projectGenerator, eventPublisher);
        this.gitHubOAuthClient = gitHubOAuthClient;
        this.gitHubApiClient = gitHubApiClient;
        this.gitHubConfiguration = gitHubConfiguration;
    }

    protected GitHubRepository creatApp(@NonNull ApplicationType type, @NonNull String name, @Nullable List<String> features, @Nullable BuildTool buildTool, @Nullable TestFramework testFramework, @Nullable Language lang, @Nullable JdkVersion javaVersion, @NonNull String code, @NonNull String state, @Nullable String userAgent) {
        AccessToken accessToken = this.getGitHubAccessToken(code, state);
        String authToken = TOKEN_PREFIX + accessToken.getAccessToken();
        GitHubUser gitHubUser = this.getGitHubUser(authToken);
        GeneratorContext generatorContext = this.createProjectGeneratorContext(type, name, features, buildTool, testFramework, lang, javaVersion, userAgent);
        String repoName = generatorContext.getProject().getName();
        String repoDescription = String.format("Micronaut %s Application", generatorContext.getProject().getNaturalName());
        GitHubRepository githubRepository = this.createGitHubRepository(authToken, repoName, repoDescription, gitHubUser);
        this.pushToGithubRepository(generatorContext, gitHubUser, githubRepository, accessToken);
        return githubRepository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushToGithubRepository(GeneratorContext generatorContext, GitHubUser gitHubUser, GitHubRepository githubRepository, AccessToken accessToken) {
        Path repoPath = null;
        try {
            repoPath = Files.createTempDirectory(Paths.get(TMP_DIR, new String[0]), REPO_PREFIX, new FileAttribute[0]);
            this.generateAppLocally(generatorContext, repoPath);
            GitHubUtil.initAndPushToGitHubRepository((GitHubRepository)githubRepository, (GitHubUser)gitHubUser, (Path)repoPath, (String)accessToken.getAccessToken());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully pushed application to " + githubRepository);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to push to created repository: " + githubRepository.getUrl());
            }
            catch (Throwable throwable) {
                try {
                    if (repoPath == null) throw throwable;
                    GitHubCreateService.deleteDirectory(repoPath);
                    throw throwable;
                }
                catch (IOException e2) {
                    LOG.error("Error cleaning up temporary project directory: " + e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            if (repoPath == null) return;
            GitHubCreateService.deleteDirectory(repoPath);
            return;
        }
        catch (IOException e) {
            LOG.error("Error cleaning up temporary project directory: " + e.getMessage(), (Throwable)e);
            return;
        }
    }

    private GitHubRepository createGitHubRepository(String authToken, String repoName, String repoDescription, GitHubUser gitHubUser) {
        try {
            if (this.gitHubApiClient.getRepository(authToken, gitHubUser.getLogin(), repoName) != null) {
                throw new IllegalArgumentException("Repository " + repoName + " already exists.");
            }
            GitHubRepository githubRepository = this.gitHubApiClient.createRepository(authToken, new GitHubRepository(repoName, repoDescription));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created repository " + githubRepository);
            }
            return githubRepository;
        }
        catch (HttpClientResponseException e) {
            throw new RuntimeException("Failed to create repository " + repoName);
        }
    }

    private AccessToken getGitHubAccessToken(String code, String state) {
        try {
            return this.gitHubOAuthClient.accessToken(this.gitHubConfiguration.getClientId(), this.gitHubConfiguration.getClientSecret(), code, state);
        }
        catch (HttpClientResponseException e) {
            throw new RuntimeException("Failed to get user access token.");
        }
    }

    private GitHubUser getGitHubUser(String authToken) {
        try {
            GitHubUser gitHubUser = this.gitHubApiClient.getUser(authToken);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetched user " + gitHubUser);
            }
            return gitHubUser;
        }
        catch (HttpClientResponseException e) {
            throw new RuntimeException("Failed to get user.");
        }
    }

    protected void generateAppLocally(@NotNull GeneratorContext generatorContext, @NotNull Path repoPath) throws IOException {
        try {
            if (!Files.isDirectory(repoPath, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("The path %s must be a directory!", repoPath.toString()));
            }
            FileSystemOutputHandler outputHandler = new FileSystemOutputHandler(repoPath.toFile(), ConsoleOutput.NOOP);
            this.projectGenerator.generate(generatorContext.getApplicationType(), generatorContext.getProject(), (OutputHandler)outputHandler, generatorContext);
        }
        catch (Exception e) {
            LOG.error("Error generating application: " + e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
    }

    private static void deleteDirectory(Path dir) throws IOException {
        Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }
}

