/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Described;
import io.micronaut.core.naming.Named;
import io.micronaut.starter.api.Linkable;
import io.micronaut.starter.api.Selectable;
import io.micronaut.starter.defaults.IncludesDefaults;
import io.micronaut.starter.defaults.LanguageDefaults;
import io.micronaut.starter.options.Language;
import io.micronaut.starter.util.NameUtils;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(name="LanguageInfo")
@Introspected
public class LanguageDTO
extends Linkable
implements Named,
Described,
Selectable<Language>,
IncludesDefaults<LanguageDefaults> {
    static final String MESSAGE_PREFIX = "micronaut.starter.language.";
    private final String name;
    private final String extension;
    private final String description;
    private final Language value;

    public LanguageDTO(Language language) {
        this.value = language;
        this.name = language.getName();
        this.extension = language.getExtension();
        this.description = language.getName();
    }

    @Creator
    @Internal
    LanguageDTO(Language value, String name, String extension, String description) {
        this.value = value;
        this.name = name;
        this.extension = extension;
        this.description = description;
    }

    @Internal
    LanguageDTO(Language language, MessageSource messageSource, MessageSource.MessageContext messageContext) {
        String name;
        this.value = language;
        this.name = name = language.getName();
        this.extension = language.getExtension();
        this.description = messageSource.getMessage(MESSAGE_PREFIX + name + ".description", messageContext, name);
    }

    @Schema(description="The extension of the language")
    public String getExtension() {
        return this.extension;
    }

    @Override
    @Schema(description="A description of the language")
    public String getDescription() {
        return this.description;
    }

    @Schema(description="The name of the language")
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(description="The value of the language for select options")
    public Language getValue() {
        return this.value;
    }

    @Override
    @Schema(description="The label of the language for select options")
    public String getLabel() {
        return NameUtils.getNaturalNameOfEnum((String)this.name);
    }

    @Schema(description="The default values that correlate to the language")
    public LanguageDefaults getDefaults() {
        return this.value.getDefaults();
    }
}

