/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.starter.api.LinkDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.LinkedHashMap;
import java.util.Map;

@Introspected
public abstract class Linkable {
    private final Map<String, LinkDTO> links = new LinkedHashMap<String, LinkDTO>();

    @Schema(description="Links to other resources")
    @JsonProperty(value="_links")
    @ReflectiveAccess
    public Map<String, LinkDTO> getLinks() {
        return this.links;
    }

    public Linkable addLink(CharSequence rel, LinkDTO link) {
        if (link != null && rel != null) {
            this.links.put(rel.toString(), link);
        }
        return this;
    }
}

