/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.http.HttpParameters;
import io.micronaut.starter.api.LinkDTO;
import io.micronaut.starter.api.Relationship;
import io.micronaut.starter.application.ApplicationType;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.Locale;
import java.util.Objects;

@Hidden
public class RequestInfo {
    public static final RequestInfo LOCAL = new RequestInfo("http://localhost:8080", "/", null, Locale.ENGLISH, "");
    private final String serverURL;
    private final String currentURL;
    private final String path;
    private final HttpParameters parameters;
    private final Locale locale;
    private final String userAgent;

    public RequestInfo(String serverURL, String path, HttpParameters parameters, Locale locale, String userAgent) {
        this.serverURL = Objects.requireNonNull(serverURL, "URL cannot be null");
        this.locale = locale;
        this.path = path;
        this.parameters = parameters;
        this.userAgent = userAgent;
        this.currentURL = serverURL + Objects.requireNonNull(path, "Path cannot be null");
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getCurrentURL() {
        return this.currentURL;
    }

    public LinkDTO self() {
        return new LinkDTO(this.getCurrentURL(), false);
    }

    public LinkDTO link(Relationship rel, ApplicationType type) {
        return new LinkDTO(this.getServerURL() + "/" + rel + "/" + type.getName() + "/{name}");
    }

    public LinkDTO link(ApplicationType type) {
        return new LinkDTO(this.getServerURL() + "/application-types/" + type.getName(), false);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public LinkDTO link(String uri) {
        return new LinkDTO(this.getServerURL() + uri, false);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getPath() {
        return this.path;
    }

    public HttpParameters getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "RequestInfo{serverURL='%s', currentURL='%s', path='%s', parameters=%s, locale=%s, userAgent='%s'}".formatted(this.serverURL, this.currentURL, this.path, this.parameters, this.locale, this.userAgent);
    }
}

