/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Described;
import io.micronaut.core.naming.Named;
import io.micronaut.starter.api.LanguageDTO;
import io.micronaut.starter.api.Linkable;
import io.micronaut.starter.api.Selectable;
import io.micronaut.starter.options.TestFramework;
import io.micronaut.starter.util.NameUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;

@Schema(name="TestFrameworkInfo")
@Introspected
public class TestFrameworkDTO
extends Linkable
implements Named,
Described,
Selectable<TestFramework> {
    static final String MESSAGE_PREFIX = "micronaut.starter.testFramework.";
    private final String name;
    private final String description;
    private final LanguageDTO defaultLanguage;
    private final List<LanguageDTO> supportedLanguages;
    private final TestFramework value;

    public TestFrameworkDTO(TestFramework testFramework) {
        this.value = testFramework;
        this.name = testFramework.toString();
        this.description = testFramework.name();
        this.defaultLanguage = new LanguageDTO(testFramework.getDefaultLanguage());
        this.supportedLanguages = testFramework.getSupportedLanguages().stream().map(LanguageDTO::new).collect(Collectors.toList());
    }

    @Creator
    @Internal
    TestFrameworkDTO(TestFramework value, String name, String description, LanguageDTO defaultLanguage, List<LanguageDTO> supportedLanguages) {
        this.value = value;
        this.name = name;
        this.description = description;
        this.defaultLanguage = defaultLanguage;
        this.supportedLanguages = supportedLanguages;
    }

    @Internal
    TestFrameworkDTO(TestFramework testFramework, MessageSource messageSource, MessageSource.MessageContext messageContext) {
        this.value = testFramework;
        this.name = testFramework.toString();
        this.description = messageSource.getMessage(MESSAGE_PREFIX + this.name + ".description", messageContext, NameUtils.getNaturalNameOfEnum((String)this.name));
        this.defaultLanguage = new LanguageDTO(testFramework.getDefaultLanguage());
        this.supportedLanguages = testFramework.getSupportedLanguages().stream().map(LanguageDTO::new).collect(Collectors.toList());
    }

    @Override
    @Schema(description="A description of the testFramework")
    public String getDescription() {
        return this.description;
    }

    @Schema(description="The name of the testFramework")
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(description="The value of the testFramework for select options")
    @NonNull
    public TestFramework getValue() {
        return this.value;
    }

    @Override
    @Schema(description="The label of the testFramework for select options")
    public String getLabel() {
        return this.description;
    }
}

