/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api.preview;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.starter.api.Relationship;
import io.micronaut.starter.api.RequestInfo;
import io.micronaut.starter.api.TestFramework;
import io.micronaut.starter.api.create.AbstractCreateController;
import io.micronaut.starter.api.preview.PreviewDTO;
import io.micronaut.starter.api.preview.PreviewOperations;
import io.micronaut.starter.application.ApplicationType;
import io.micronaut.starter.application.Project;
import io.micronaut.starter.application.generator.ProjectGenerator;
import io.micronaut.starter.io.ConsoleOutput;
import io.micronaut.starter.io.MapOutputHandler;
import io.micronaut.starter.io.OutputHandler;
import io.micronaut.starter.options.BuildTool;
import io.micronaut.starter.options.JdkVersion;
import io.micronaut.starter.options.Language;
import io.micronaut.starter.options.MicronautJdkVersionConfiguration;
import io.micronaut.starter.options.Options;
import io.micronaut.starter.util.NameUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller(value="/preview")
public class PreviewController
extends AbstractCreateController
implements PreviewOperations {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewController.class);

    public PreviewController(ProjectGenerator projectGenerator, ApplicationEventPublisher eventPublisher) {
        super(projectGenerator, eventPublisher);
    }

    @Override
    @Get(uri="/{type}/{name}{?features,lang,build,test,javaVersion}", produces={"application/json"})
    public PreviewDTO previewApp(ApplicationType type, String name, @Nullable List<String> features, @Nullable BuildTool build, @Nullable TestFramework test, @Nullable Language lang, @Nullable JdkVersion javaVersion, @Parameter(hidden=true) RequestInfo requestInfo) throws IOException {
        try {
            Project project = NameUtils.parse((String)name);
            MapOutputHandler outputHandler = new MapOutputHandler();
            this.projectGenerator.generate(type, project, new Options(lang, test != null ? test.toTestFramework() : null, build == null ? BuildTool.DEFAULT_OPTION : build, javaVersion == null ? MicronautJdkVersionConfiguration.DEFAULT_OPTION : javaVersion), this.getOperatingSystem(requestInfo.getUserAgent()), features == null ? Collections.emptyList() : features, (OutputHandler)outputHandler, ConsoleOutput.NOOP);
            Map contents = outputHandler.getProject();
            PreviewDTO previewDTO = new PreviewDTO(contents);
            previewDTO.addLink(Relationship.CREATE, requestInfo.link(Relationship.CREATE, type));
            previewDTO.addLink(Relationship.SELF, requestInfo.self());
            return previewDTO;
        }
        catch (IllegalArgumentException e) {
            throw new HttpStatusException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Error generating application: {}", (Object)e.getMessage(), (Object)e);
            throw new IOException(e.getMessage(), e);
        }
    }
}

