/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import com.fizzed.rocker.RockerModel;
import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.Writable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.starter.api.ApplicationTypeDTO;
import io.micronaut.starter.api.ApplicationTypeList;
import io.micronaut.starter.api.ApplicationTypeOperations;
import io.micronaut.starter.api.FeatureDTO;
import io.micronaut.starter.api.FeatureList;
import io.micronaut.starter.api.FeatureOperations;
import io.micronaut.starter.api.Relationship;
import io.micronaut.starter.api.RequestInfo;
import io.micronaut.starter.api.StarterConfiguration;
import io.micronaut.starter.api.VersionDTO;
import io.micronaut.starter.application.ApplicationType;
import io.micronaut.starter.template.RockerWritable;
import io.micronaut.starter.template.api.starterApi;
import io.micronaut.starter.util.VersionInfo;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@OpenAPIDefinition(info=@Info(title="Micronaut Launch", version="${api.version}", description="API for Creating Micronaut Applications", license=@License(name="Apache 2.0")))
@Controller
public class ApplicationController
implements ApplicationTypeOperations {
    private final FeatureOperations featureOperations;
    private final StarterConfiguration configuration;
    private final MessageSource messageSource;

    public ApplicationController(FeatureOperations featureOperations, StarterConfiguration configuration, MessageSource messageSource) {
        this.featureOperations = featureOperations;
        this.configuration = configuration;
        this.messageSource = messageSource;
    }

    @Get(value="/versions")
    VersionDTO getInfo(@Parameter(hidden=true) RequestInfo info) {
        return new VersionDTO().addLink(Relationship.SELF, info.self());
    }

    @Hidden
    @Get
    @ApiResponse(responseCode="200", description="A textual description of the API", content={@Content(mediaType="text/plain")})
    @Produces(value={"text/plain", "text/html"})
    HttpResponse<?> redirectToUi(HttpRequest<?> request, @Parameter(hidden=true) RequestInfo info) {
        URI redirectURI = this.configuration.getRedirectUri().orElse(null);
        boolean acceptsHtml = request.accept().stream().anyMatch(mediaType -> mediaType.equals((Object)MediaType.TEXT_HTML_TYPE));
        if (acceptsHtml && redirectURI != null) {
            return HttpResponse.permanentRedirect((URI)redirectURI);
        }
        return this.home(request, info).contentType(MediaType.TEXT_PLAIN_TYPE);
    }

    MutableHttpResponse<Writable> home(HttpRequest<?> request, final @Parameter(hidden=true) RequestInfo info) {
        return HttpResponse.ok((Object)new Writable(){

            public void writeTo(Writer out) {
            }

            public void writeTo(OutputStream outputStream, @Nullable Charset charset) {
                new RockerWritable((RockerModel)new starterApi().serverURL(info.getServerURL()).micronautVersion(VersionInfo.getMicronautVersion())).write(outputStream);
            }
        });
    }

    @Override
    @Get(value="/application-types")
    public ApplicationTypeList list(RequestInfo info) {
        List<ApplicationTypeDTO> types = Arrays.stream(ApplicationType.values()).map(type -> this.typeToDTO((ApplicationType)type, info, false)).collect(Collectors.toList());
        ApplicationTypeList applicationTypeList = new ApplicationTypeList(types);
        applicationTypeList.addLink(Relationship.SELF, info.self());
        return applicationTypeList;
    }

    @Override
    @Get(value="/application-types/{type}")
    public ApplicationTypeDTO getType(ApplicationType type, RequestInfo info) {
        return this.typeToDTO(type, info, true);
    }

    @Override
    @Get(value="/application-types/{type}/features")
    public FeatureList features(ApplicationType type, RequestInfo requestInfo) {
        FeatureList featureList = new FeatureList(this.featureOperations.getFeatures(requestInfo.getLocale(), type));
        featureList.addLink(Relationship.SELF, requestInfo.self());
        return featureList;
    }

    private ApplicationTypeDTO typeToDTO(ApplicationType type, RequestInfo requestInfo, boolean includeFeatures) {
        List<FeatureDTO> features = includeFeatures ? this.featureOperations.getFeatures(requestInfo.getLocale(), type) : Collections.emptyList();
        features.forEach(featureDTO -> featureDTO.addLink(Relationship.DIFF, requestInfo.link("/diff/" + type.getName() + "/feature/" + featureDTO.getName())));
        ApplicationTypeDTO dto = new ApplicationTypeDTO(type, features, this.messageSource, MessageSource.MessageContext.of((Locale)requestInfo.getLocale()));
        dto.addLink(Relationship.CREATE, requestInfo.link(Relationship.CREATE, type));
        dto.addLink(Relationship.PREVIEW, requestInfo.link(Relationship.PREVIEW, type));
        dto.addLink(Relationship.SELF, requestInfo.link(type));
        return dto;
    }
}

