/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.starter.api.Selectable;
import io.micronaut.starter.options.BuildTool;
import io.micronaut.starter.util.NameUtils;
import io.swagger.v3.oas.annotations.media.Schema;

@Introspected
@Schema(name="BuildToolInfo")
public class BuildToolDTO
implements Selectable<BuildTool> {
    static final String MESSAGE_PREFIX = "micronaut.starter.buildTools.";
    BuildTool value;
    String label;
    String description;

    public BuildToolDTO(BuildTool buildTool) {
        this.value = buildTool;
        this.label = buildTool.name();
        this.description = buildTool.name();
    }

    @Internal
    public BuildToolDTO(BuildTool buildTool, MessageSource messageSource, MessageSource.MessageContext messageContext) {
        this.value = buildTool;
        String label = NameUtils.getNaturalNameOfEnum((String)buildTool.name());
        this.label = messageSource.getMessage(MESSAGE_PREFIX + String.valueOf(this.value) + ".label", messageContext, label);
        this.description = messageSource.getMessage(MESSAGE_PREFIX + String.valueOf(this.value) + ".description", messageContext, label);
    }

    @Creator
    public BuildToolDTO(BuildTool value, String label, String description) {
        this.value = value;
        this.label = label;
        this.description = description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public BuildTool getValue() {
        return this.value;
    }
}

