/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api.analytics;

import io.micronaut.context.annotation.Requires;
import io.micronaut.runtime.event.annotation.EventListener;
import io.micronaut.starter.analytics.Generated;
import io.micronaut.starter.analytics.SelectedFeature;
import io.micronaut.starter.api.analytics.AnalyticsOperations;
import io.micronaut.starter.api.event.ApplicationGeneratingEvent;
import io.micronaut.starter.application.generator.GeneratorContext;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(beans={AnalyticsOperations.class})
public class GenerationListener {
    private static final Logger LOG = LoggerFactory.getLogger(GenerationListener.class);
    private final AnalyticsOperations analyticsOperations;

    public GenerationListener(AnalyticsOperations analyticsOperations) {
        this.analyticsOperations = analyticsOperations;
    }

    @EventListener
    void onApplicationGenerated(ApplicationGeneratingEvent event) {
        GeneratorContext context = event.getSource();
        List features = context.getFeatures().stream().map(SelectedFeature::new).collect(Collectors.toList());
        Generated generated = new Generated(context.getApplicationType(), context.getLanguage(), context.getBuildTool(), context.getTestFramework(), context.getJdkVersion());
        generated.setSelectedFeatures(features);
        if (this.analyticsOperations != null) {
            this.analyticsOperations.applicationGenerated(generated).whenComplete((httpStatus, throwable) -> {
                if (throwable != null && LOG.isErrorEnabled()) {
                    LOG.error("Error occurred reporting analytics: {}", (Object)throwable.getMessage(), throwable);
                }
            });
        }
    }
}

