/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.naming.Described;
import io.micronaut.core.naming.Named;
import io.micronaut.starter.api.Linkable;
import io.micronaut.starter.feature.Feature;
import io.swagger.v3.oas.annotations.media.Schema;

@Introspected
@Schema(name="Feature")
public class FeatureDTO
extends Linkable
implements Named,
Described {
    static final String MESSAGE_PREFIX = "micronaut.starter.features.";
    private final String name;
    private final String title;
    private final String description;
    private final String category;
    private final boolean preview;
    private final boolean community;

    public FeatureDTO(Feature feature, MessageSource messageSource, MessageSource.MessageContext messageContext) {
        this.name = feature.getName();
        this.title = messageSource.getMessage(MESSAGE_PREFIX + this.name + ".title", messageContext, feature.getTitle());
        this.description = messageSource.getMessage(MESSAGE_PREFIX + this.name + ".description", messageContext, feature.getDescription());
        this.category = feature.getCategory();
        this.preview = feature.isPreview();
        this.community = feature.isCommunity();
    }

    @Creator
    public FeatureDTO(String name, String title, String description, String category, boolean preview, boolean community) {
        this.name = name;
        this.title = title;
        this.description = description;
        this.category = category;
        this.preview = preview;
        this.community = community;
    }

    @Schema(description="The name of the feature")
    public String getName() {
        return this.name;
    }

    @Schema(description="The title of the feature")
    public String getTitle() {
        return this.title;
    }

    @Schema(description="A description of the feature")
    public String getDescription() {
        return this.description;
    }

    @Schema(description="The category to which this feature belongs to")
    public String getCategory() {
        return this.category;
    }

    @Schema(description="Indicates whether the feature is a preview feature and subject to change")
    public boolean isPreview() {
        return this.preview;
    }

    @Schema(description="Indicates whether the feature is a community contributed feature")
    public boolean isCommunity() {
        return this.community;
    }
}

