/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api.create.zip;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.io.Writable;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.scheduling.annotation.ExecuteOn;
import io.micronaut.starter.api.TestFramework;
import io.micronaut.starter.api.create.AbstractCreateController;
import io.micronaut.starter.api.create.zip.ZipCreateOperation;
import io.micronaut.starter.application.ApplicationType;
import io.micronaut.starter.application.Project;
import io.micronaut.starter.application.generator.GeneratorContext;
import io.micronaut.starter.application.generator.ProjectGenerator;
import io.micronaut.starter.io.OutputHandler;
import io.micronaut.starter.io.ZipOutputHandler;
import io.micronaut.starter.options.BuildTool;
import io.micronaut.starter.options.JdkVersion;
import io.micronaut.starter.options.Language;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@ExecuteOn(value="blocking")
public class ZipCreateController
extends AbstractCreateController
implements ZipCreateOperation {
    public static final String MEDIA_TYPE_APPLICATION_ZIP = "application/zip";
    private static final Logger LOG = LoggerFactory.getLogger(ZipCreateController.class);

    public ZipCreateController(ProjectGenerator projectGenerator, ApplicationEventPublisher eventPublisher) {
        super(projectGenerator, eventPublisher);
    }

    @Override
    @Get(uri="/create/{type}/{name}{?features,lang,build,test,javaVersion}", produces={"application/zip"})
    @ApiResponse(description="A ZIP file containing the generated application.", content={@Content(mediaType="application/zip")})
    public HttpResponse<Writable> createApp(ApplicationType type, @Pattern(regexp="[\\w\\d-_\\.]+") @Pattern(regexp="[\\w\\d-_\\.]+") String name, @Nullable List<String> features, @Nullable BuildTool build, @Nullable TestFramework test, @Nullable Language lang, @Nullable JdkVersion javaVersion, @Nullable @Header(value="User-Agent") String userAgent) {
        return this.generateAppIntoZipFile(type, name, features, build, test, lang, javaVersion, userAgent);
    }

    @Get(uri="/{name}.zip{?type,features,lang,build,test}", produces={"application/zip"})
    @ApiResponse(description="A ZIP file containing the generated application.", content={@Content(mediaType="application/zip")})
    public HttpResponse<Writable> createZip(@Bindable(defaultValue="default") ApplicationType type, @Pattern(regexp="[\\w\\d-_]+") @NotBlank @Pattern(regexp="[\\w\\d-_]+") @NotBlank String name, @Nullable List<String> features, @Nullable BuildTool build, @Nullable TestFramework test, @Nullable Language lang, @Nullable JdkVersion javaVersion, @Nullable @Header(value="User-Agent") String userAgent) {
        return this.generateAppIntoZipFile(type, name, features, build, test, lang, javaVersion, userAgent);
    }

    public HttpResponse<Writable> generateAppIntoZipFile(final @NotNull ApplicationType type, @NotNull String name, @Nullable List<String> features, @Nullable BuildTool buildTool, @Nullable TestFramework testFramework, @Nullable Language lang, @Nullable JdkVersion javaVersion, @Nullable String userAgent) {
        final GeneratorContext generatorContext = this.createProjectGeneratorContext(type, name, features, buildTool, testFramework, lang, javaVersion, userAgent);
        MutableHttpResponse response = HttpResponse.created((Object)new Writable(){

            public void writeTo(OutputStream outputStream, @Nullable Charset charset) throws IOException {
                try {
                    Project project = generatorContext.getProject();
                    ZipCreateController.this.projectGenerator.generate(type, project, (OutputHandler)new ZipOutputHandler(project.getName(), outputStream), generatorContext);
                    outputStream.flush();
                }
                catch (Exception e) {
                    LOG.error("Error generating application: {}", (Object)e.getMessage(), (Object)e);
                    throw new IOException(e.getMessage(), e);
                }
            }

            public void writeTo(Writer out) {
            }
        });
        return response.header((CharSequence)"Content-Disposition", (CharSequence)("attachment; filename=" + this.getFilename(generatorContext.getProject())));
    }

    @NonNull
    protected String getFilename(@NonNull Project project) {
        return project.getName() + ".zip";
    }
}

