/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.starter.api.diff;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.starter.api.RequestInfo;
import io.micronaut.starter.api.UserAgentParser;
import io.micronaut.starter.api.diff.DiffOperations;
import io.micronaut.starter.application.ApplicationType;
import io.micronaut.starter.application.Project;
import io.micronaut.starter.application.generator.GeneratorContext;
import io.micronaut.starter.application.generator.ProjectGenerator;
import io.micronaut.starter.diff.FeatureDiffer;
import io.micronaut.starter.io.ConsoleOutput;
import io.micronaut.starter.options.BuildTool;
import io.micronaut.starter.options.JdkVersion;
import io.micronaut.starter.options.Language;
import io.micronaut.starter.options.MicronautJdkVersionConfiguration;
import io.micronaut.starter.options.Options;
import io.micronaut.starter.options.TestFramework;
import io.micronaut.starter.util.NameUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@Controller(value="/diff")
public class DiffController
implements DiffOperations {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final ProjectGenerator projectGenerator;
    private final FeatureDiffer featureDiffer;
    private final Project project;

    public DiffController(ProjectGenerator projectGenerator, FeatureDiffer featureDiffer) {
        this.projectGenerator = projectGenerator;
        this.featureDiffer = featureDiffer;
        this.project = NameUtils.parse((String)"example");
    }

    @Override
    @Get(uri="/{type}/feature/{feature}{?lang,build,test,javaVersion,name}", produces={"text/plain"})
    @ApiResponses(value={@ApiResponse(responseCode="404", description="If no difference is found"), @ApiResponse(responseCode="400", description="If the supplied parameters are invalid"), @ApiResponse(responseCode="200", description="A textual diff", content={@Content(mediaType="text/plain")})})
    public String diffFeature(@NotNull ApplicationType type, @Nullable String name, @NonNull @NotBlank String feature, @Nullable BuildTool build, @Nullable TestFramework test, @Nullable Language lang, @Nullable JdkVersion javaVersion, @Parameter(hidden=true) RequestInfo requestInfo) {
        GeneratorContext generatorContext;
        ProjectGenerator projectGenerator;
        try {
            Project project = name != null ? NameUtils.parse((String)name) : this.project;
            Language language = lang != null ? lang : Language.DEFAULT_OPTION;
            Options options = new Options(language, test != null ? test : language.getDefaults().getTest(), build != null ? build : language.getDefaults().getBuild(), javaVersion != null ? javaVersion : MicronautJdkVersionConfiguration.DEFAULT_OPTION);
            projectGenerator = this.projectGenerator;
            generatorContext = projectGenerator.createGeneratorContext(type, project, options, UserAgentParser.getOperatingSystem(requestInfo.getUserAgent()), Collections.singletonList(feature), ConsoleOutput.NOOP);
        }
        catch (IllegalArgumentException e) {
            throw new HttpStatusException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
        return this.diff(projectGenerator, generatorContext);
    }

    @Override
    @Get(uri="/{type}/{name}{?features,lang,build,test,javaVersion}", produces={"text/plain"})
    @ApiResponses(value={@ApiResponse(responseCode="404", description="If no difference is found"), @ApiResponse(responseCode="400", description="If the supplied parameters are invalid"), @ApiResponse(responseCode="200", description="A textual diff", content={@Content(mediaType="text/plain")})})
    public String diffApp(ApplicationType type, @Pattern(regexp="[\\w\\d-_\\.]+") @Pattern(regexp="[\\w\\d-_\\.]+") String name, @Nullable List<String> features, @Nullable BuildTool build, @Nullable TestFramework test, @Nullable Language lang, @Nullable JdkVersion javaVersion, @Parameter(hidden=true) RequestInfo requestInfo) throws IOException {
        GeneratorContext generatorContext;
        ProjectGenerator projectGenerator;
        try {
            Project project = name != null ? NameUtils.parse((String)name) : this.project;
            Language language = lang != null ? lang : Language.DEFAULT_OPTION;
            Options options = new Options(language, test != null ? test : language.getDefaults().getTest(), build != null ? build : language.getDefaults().getBuild(), javaVersion != null ? javaVersion : MicronautJdkVersionConfiguration.DEFAULT_OPTION);
            projectGenerator = this.projectGenerator;
            generatorContext = projectGenerator.createGeneratorContext(type, project, options, UserAgentParser.getOperatingSystem(requestInfo.getUserAgent()), features != null ? features : Collections.emptyList(), ConsoleOutput.NOOP);
        }
        catch (IllegalArgumentException e) {
            throw new HttpStatusException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
        return this.diff(projectGenerator, generatorContext);
    }

    private String diff(ProjectGenerator projectGenerator, GeneratorContext generatorContext) {
        final StringBuilder sb = new StringBuilder();
        try {
            this.featureDiffer.produceDiff(projectGenerator, generatorContext, new ConsoleOutput(){

                public void out(String message) {
                    sb.append(message).append(LINE_SEPARATOR);
                }

                public void err(String message) {
                }

                public void warning(String message) {
                }

                public boolean showStacktrace() {
                    return false;
                }

                public boolean verbose() {
                    return false;
                }
            });
            return sb.toString();
        }
        catch (Exception e) {
            throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Could not produce diff: " + e.getMessage());
        }
    }
}

