/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.extensions.junit5;

import io.micronaut.aop.InterceptedProxy;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.test.annotation.MicronautTest;
import io.micronaut.test.annotation.MockBean;
import io.micronaut.test.extensions.AbstractMicronautExtension;
import io.micronaut.test.support.TestPropertyProvider;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.platform.commons.support.AnnotationSupport;

public class MicronautJunit5Extension
extends AbstractMicronautExtension<ExtensionContext>
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ExecutionCondition,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver {
    public void beforeAll(ExtensionContext extensionContext) {
        TestInstance ti;
        Class testClass = extensionContext.getRequiredTestClass();
        MicronautTest micronautTest = AnnotationSupport.findAnnotation((AnnotatedElement)testClass, MicronautTest.class).orElse(null);
        this.beforeClass(extensionContext, testClass, micronautTest);
        if (this.specDefinition != null && (ti = (TestInstance)AnnotationSupport.findAnnotation((AnnotatedElement)testClass, TestInstance.class).orElse(null)) != null && ti.value() == TestInstance.Lifecycle.PER_CLASS) {
            Object testInstance = extensionContext.getRequiredTestInstance();
            this.applicationContext.inject(testInstance);
        }
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.afterClass(extensionContext);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        Optional testInstance = extensionContext.getTestInstance();
        Optional testMethod = extensionContext.getTestMethod();
        List<Property> propertyAnnotations = null;
        if (testMethod.isPresent()) {
            Property[] annotationsByType = (Property[])((AnnotatedElement)testMethod.get()).getAnnotationsByType(Property.class);
            propertyAnnotations = Arrays.asList(annotationsByType);
        }
        this.beforeEach(extensionContext, testInstance.orElse(null), testMethod.orElse(null), propertyAnnotations);
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        Optional testInstance = extensionContext.getTestInstance();
        if (testInstance.isPresent()) {
            Class requiredTestClass = extensionContext.getRequiredTestClass();
            if (this.applicationContext.containsBean(requiredTestClass)) {
                return ConditionEvaluationResult.enabled((String)"Test bean active");
            }
            boolean hasBeanDefinition = this.isTestSuiteBeanPresent(requiredTestClass);
            if (!hasBeanDefinition) {
                throw new TestInstantiationException("@MicronautTest used on test but no bean definition for the test present. This error indicates a misconfigured build or IDE. Please add the 'micronaut-inject-java' annotation processor to your test processor path (for Java this is the testAnnotationProcessor scope, for Kotlin kaptTest and for Groovy testCompile). See the documentation for reference: https://micronaut-projects.github.io/micronaut-test/latest/guide/");
            }
            return ConditionEvaluationResult.disabled((String)"Test is not bean. Either the test does not satisfy requirements defined by @Requires or annotation processing is not enabled. If the latter ensure annotation processing is enabled in your IDE.");
        }
        Class testClass = extensionContext.getRequiredTestClass();
        if (AnnotationSupport.isAnnotated((AnnotatedElement)testClass, MicronautTest.class)) {
            return ConditionEvaluationResult.enabled((String)"Test bean active");
        }
        return ConditionEvaluationResult.disabled((String)"Test is not bean. Either the test does not satisfy requirements defined by @Requires or annotation processing is not enabled. If the latter ensure annotation processing is enabled in your IDE.");
    }

    protected void resolveTestProperties(ExtensionContext context, MicronautTest testAnnotation, Map<String, Object> testProperties) {
        Map properties;
        Object o = context.getTestInstance().orElse(null);
        if (o instanceof TestPropertyProvider && CollectionUtils.isNotEmpty((Map)(properties = ((TestPropertyProvider)o).getProperties()))) {
            testProperties.putAll(properties);
        }
    }

    protected void alignMocks(ExtensionContext context, Object instance) {
        if (this.specDefinition != null) {
            for (FieldInjectionPoint injectedField : this.specDefinition.getInjectedFields()) {
                boolean isMock = this.applicationContext.resolveMetadata(injectedField.getType()).isAnnotationPresent(MockBean.class);
                if (!isMock) continue;
                Field field = injectedField.getField();
                field.setAccessible(true);
                try {
                    Object mock = field.get(instance);
                    if (!(mock instanceof InterceptedProxy)) continue;
                    InterceptedProxy ip = (InterceptedProxy)mock;
                    Object target = ip.interceptedTarget();
                    field.set(instance, target);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.commit();
        this.rollback();
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.begin();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.applicationContext != null && this.applicationContext.containsBean(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Named named = parameterContext.findAnnotation(Named.class).orElse(null);
        if (named != null) {
            return this.applicationContext.getBean(parameterContext.getParameter().getType(), Qualifiers.byName((String)named.value()));
        }
        return this.applicationContext.getBean(parameterContext.getParameter().getType());
    }
}

