/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.extensions.junit5;

import io.micronaut.aop.InterceptedProxy;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.test.annotation.AnnotationUtils;
import io.micronaut.test.annotation.MicronautTestValue;
import io.micronaut.test.annotation.MockBean;
import io.micronaut.test.context.TestContext;
import io.micronaut.test.extensions.AbstractMicronautExtension;
import io.micronaut.test.extensions.junit5.annotation.MicronautTest;
import io.micronaut.test.support.TestPropertyProvider;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.platform.commons.support.AnnotationSupport;

public class MicronautJunit5Extension
extends AbstractMicronautExtension<ExtensionContext>
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ExecutionCondition,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver,
InvocationInterceptor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MicronautJunit5Extension.class});

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        TestInstance ti;
        Class testClass = extensionContext.getRequiredTestClass();
        MicronautTestValue micronautTestValue = this.buildMicronautTestValue(testClass);
        this.beforeClass(extensionContext, testClass, micronautTestValue);
        this.getStore(extensionContext).put(ApplicationContext.class, (Object)this.applicationContext);
        if (this.specDefinition != null && (ti = (TestInstance)AnnotationSupport.findAnnotation((AnnotatedElement)testClass, TestInstance.class).orElse(null)) != null && ti.value() == TestInstance.Lifecycle.PER_CLASS) {
            Object testInstance = extensionContext.getRequiredTestInstance();
            this.applicationContext.inject(testInstance);
        }
        this.beforeTestClass(this.buildContext(extensionContext));
    }

    protected MicronautTestValue buildMicronautTestValue(Class<?> testClass) {
        Optional micronautTest = AnnotationSupport.findAnnotation(testClass, io.micronaut.test.annotation.MicronautTest.class);
        return micronautTest.map(AnnotationUtils::buildValueObject).orElseGet(() -> AnnotationSupport.findAnnotation((AnnotatedElement)testClass, MicronautTest.class).map(this::buildValueObject).orElse(null));
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.beforeSetupTest(this.buildContext(extensionContext));
        invocation.proceed();
        this.afterSetupTest(this.buildContext(extensionContext));
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.beforeCleanupTest(this.buildContext(extensionContext));
        invocation.proceed();
        this.afterCleanupTest(this.buildContext(extensionContext));
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.afterTestClass(this.buildContext(extensionContext));
        if (!extensionContext.getTestClass().filter(this::isNestedTestClass).isPresent()) {
            this.afterClass(extensionContext);
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.injectEnclosingTestInstances(extensionContext);
        Optional testInstance = extensionContext.getTestInstance();
        Optional testMethod = extensionContext.getTestMethod();
        List<Property> propertyAnnotations = null;
        if (testMethod.isPresent()) {
            Property[] annotationsByType = (Property[])((AnnotatedElement)testMethod.get()).getAnnotationsByType(Property.class);
            propertyAnnotations = Arrays.asList(annotationsByType);
        }
        this.beforeEach(extensionContext, testInstance.orElse(null), testMethod.orElse(null), propertyAnnotations);
        this.beforeTestMethod(this.buildContext(extensionContext));
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        super.afterEach((Object)extensionContext);
        this.afterTestMethod(this.buildContext(extensionContext));
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        Optional testInstance = extensionContext.getTestInstance();
        if (testInstance.isPresent()) {
            Class requiredTestClass = extensionContext.getRequiredTestClass();
            if (this.applicationContext.containsBean(requiredTestClass) || this.isNestedTestClass(requiredTestClass)) {
                return ConditionEvaluationResult.enabled((String)"Test bean active");
            }
            boolean hasBeanDefinition = this.isTestSuiteBeanPresent(requiredTestClass);
            if (!hasBeanDefinition) {
                throw new TestInstantiationException("@MicronautTest used on test but no bean definition for the test present. This error indicates a misconfigured build or IDE. Please add the 'micronaut-inject-java' annotation processor to your test processor path (for Java this is the testAnnotationProcessor scope, for Kotlin kaptTest and for Groovy testCompile). See the documentation for reference: https://micronaut-projects.github.io/micronaut-test/latest/guide/");
            }
            return ConditionEvaluationResult.disabled((String)"Test is not bean. Either the test does not satisfy requirements defined by @Requires or annotation processing is not enabled. If the latter ensure annotation processing is enabled in your IDE.");
        }
        Class testClass = extensionContext.getRequiredTestClass();
        if (this.hasExpectedAnnotations(testClass) || this.isNestedTestClass(testClass)) {
            return ConditionEvaluationResult.enabled((String)"Test bean active");
        }
        return ConditionEvaluationResult.disabled((String)"Test is not bean. Either the test does not satisfy requirements defined by @Requires or annotation processing is not enabled. If the latter ensure annotation processing is enabled in your IDE.");
    }

    protected boolean hasExpectedAnnotations(Class<?> testClass) {
        return AnnotationSupport.isAnnotated(testClass, MicronautTest.class) || AnnotationSupport.isAnnotated(testClass, io.micronaut.test.annotation.MicronautTest.class);
    }

    protected void resolveTestProperties(ExtensionContext context, MicronautTestValue testAnnotationValue, Map<String, Object> testProperties) {
        Map properties;
        Object o = context.getTestInstance().orElse(null);
        if (o instanceof TestPropertyProvider && CollectionUtils.isNotEmpty((Map)(properties = ((TestPropertyProvider)o).getProperties()))) {
            testProperties.putAll(properties);
        }
    }

    protected void alignMocks(ExtensionContext context, Object instance) {
        if (this.specDefinition != null) {
            for (FieldInjectionPoint injectedField : this.specDefinition.getInjectedFields()) {
                boolean isMock = this.applicationContext.resolveMetadata(injectedField.getType()).isAnnotationPresent(MockBean.class);
                if (!isMock) continue;
                Field field = injectedField.getField();
                field.setAccessible(true);
                try {
                    Object mock = field.get(instance);
                    if (!(mock instanceof InterceptedProxy)) continue;
                    InterceptedProxy ip = (InterceptedProxy)mock;
                    Object target = ip.interceptedTarget();
                    field.set(instance, target);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.afterTestExecution(this.buildContext(context));
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.beforeTestExecution(this.buildContext(context));
    }

    private TestContext buildContext(ExtensionContext context) {
        return new TestContext(this.applicationContext, (Class)context.getTestClass().orElse(null), (AnnotatedElement)context.getTestMethod().orElse(null), context.getTestInstance().orElse(null), (Throwable)context.getExecutionException().orElse(null));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Argument<?> argument = this.getArgument(parameterContext, this.applicationContext);
        if (argument != null) {
            if (argument.isAnnotationPresent(Value.class) || argument.isAnnotationPresent(Property.class)) {
                return true;
            }
            return this.applicationContext.containsBean(argument.getType(), MicronautJunit5Extension.resolveQualifier(argument));
        }
        return this.applicationContext.containsBean(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Argument<?> argument = this.getArgument(parameterContext, this.applicationContext);
        if (argument != null) {
            Optional v = argument.getAnnotationMetadata().stringValue(Value.class);
            if (v.isPresent()) {
                Optional finalV = v;
                return this.applicationContext.getEnvironment().getProperty((String)v.get(), argument).orElseThrow(() -> new ParameterResolutionException("Unresolvable property specified to @Value: " + (String)finalV.get()));
            }
            v = argument.getAnnotationMetadata().stringValue(Property.class, "name");
            if (v.isPresent()) {
                Optional finalV1 = v;
                return this.applicationContext.getEnvironment().getProperty((String)v.get(), argument).orElseThrow(() -> new ParameterResolutionException("Unresolvable property specified to @Property: " + (String)finalV1.get()));
            }
            return this.applicationContext.getBean(argument.getType(), MicronautJunit5Extension.resolveQualifier(argument));
        }
        return this.applicationContext.getBean(parameterContext.getParameter().getType());
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    private MicronautTestValue buildValueObject(MicronautTest micronautTest) {
        return new MicronautTestValue(micronautTest.application(), micronautTest.environments(), micronautTest.packages(), micronautTest.propertySources(), micronautTest.rollback(), micronautTest.transactional(), micronautTest.rebuildContext(), (Class[])micronautTest.contextBuilder(), micronautTest.transactionMode(), micronautTest.startApplication());
    }

    private boolean isNestedTestClass(Class<?> testClass) {
        return AnnotationSupport.isAnnotated(testClass, Nested.class);
    }

    private void injectEnclosingTestInstances(ExtensionContext extensionContext) {
        extensionContext.getTestInstances().ifPresent(testInstances -> testInstances.getEnclosingInstances().forEach(arg_0 -> ((ApplicationContext)this.applicationContext).inject(arg_0)));
    }

    private Argument<?> getArgument(ParameterContext parameterContext, ApplicationContext applicationContext) {
        try {
            Executable declaringExecutable = parameterContext.getDeclaringExecutable();
            int index = parameterContext.getIndex();
            if (declaringExecutable instanceof Constructor) {
                Argument[] arguments;
                Class<?> declaringClass = declaringExecutable.getDeclaringClass();
                BeanDefinition beanDefinition = applicationContext.findBeanDefinition(declaringClass).orElse(null);
                if (beanDefinition != null && index < (arguments = beanDefinition.getConstructor().getArguments()).length) {
                    return arguments[index];
                }
            } else {
                ExecutableMethod executableMethod = applicationContext.getExecutableMethod(declaringExecutable.getDeclaringClass(), declaringExecutable.getName(), (Class[])declaringExecutable.getParameterTypes());
                Argument[] arguments = executableMethod.getArguments();
                if (index < arguments.length) {
                    return arguments[index];
                }
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return null;
    }

    private static <T> Qualifier<T> resolveQualifier(Argument<?> argument) {
        List qualifierTypes;
        AnnotationMetadata annotationMetadata = Objects.requireNonNull(argument, "Argument cannot be null").getAnnotationMetadata();
        boolean hasMetadata = annotationMetadata != AnnotationMetadata.EMPTY_METADATA;
        List list = qualifierTypes = hasMetadata ? annotationMetadata.getAnnotationTypesByStereotype(javax.inject.Qualifier.class) : null;
        if (CollectionUtils.isNotEmpty((Collection)qualifierTypes)) {
            if (qualifierTypes.size() == 1) {
                return Qualifiers.byAnnotation((AnnotationMetadata)annotationMetadata, (Class)((Class)qualifierTypes.iterator().next()));
            }
            Qualifier[] qualifiers = (Qualifier[])qualifierTypes.stream().map(type -> Qualifiers.byAnnotation((AnnotationMetadata)annotationMetadata, (Class)type)).toArray(Qualifier[]::new);
            return Qualifiers.byQualifiers((Qualifier[])qualifiers);
        }
        return null;
    }
}

