/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.extensions.spock;

import io.micronaut.aop.InterceptedProxy;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.test.annotation.AnnotationUtils;
import io.micronaut.test.annotation.MicronautTestValue;
import io.micronaut.test.context.TestContext;
import io.micronaut.test.extensions.AbstractMicronautExtension;
import io.micronaut.test.extensions.spock.annotation.MicronautTest;
import io.micronaut.test.support.TestPropertyProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.inject.Inject;
import org.spockframework.mock.MockUtil;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.Specification;

public class MicronautSpockExtension<T extends Annotation>
extends AbstractMicronautExtension<IMethodInvocation>
implements IAnnotationDrivenExtension<T> {
    private Queue<Object> creatableMocks = new ConcurrentLinkedDeque<Object>();
    private Queue<Object> singletonMocks = new ConcurrentLinkedDeque<Object>();
    private MockUtil mockUtil = new MockUtil();

    public void visitSpecAnnotation(T annotation, SpecInfo spec) {
        spec.getAllFeatures().forEach(feature -> {
            feature.addInterceptor(invocation -> {
                try {
                    this.beforeTestMethod(this.buildContext(invocation, null));
                    invocation.proceed();
                }
                finally {
                    this.afterTestMethod(this.buildContext(invocation, null));
                }
            });
            feature.getFeatureMethod().addInterceptor(invocation -> {
                try {
                    this.beforeTestExecution(this.buildContext(invocation, null));
                    invocation.proceed();
                    this.afterTestExecution(this.buildContext(invocation, null));
                }
                catch (Throwable e) {
                    this.afterTestExecution(this.buildContext(invocation, e));
                    throw e;
                }
            });
        });
        spec.addSetupSpecInterceptor(invocation -> {
            MicronautTest micronautTest = (MicronautTest)spec.getAnnotation(MicronautTest.class);
            MicronautTestValue micronautTestValue = micronautTest == null ? AnnotationUtils.buildValueObject((io.micronaut.test.annotation.MicronautTest)((io.micronaut.test.annotation.MicronautTest)spec.getAnnotation(io.micronaut.test.annotation.MicronautTest.class))) : this.buildValueObject(micronautTest);
            this.beforeClass(invocation, (Class)spec.getReflection(), micronautTestValue);
            if (this.specDefinition == null) {
                if (!this.isTestSuiteBeanPresent((Class)spec.getReflection())) {
                    throw new InvalidSpecException("@MicronautTest used on test but no bean definition for the test present. This error indicates a misconfigured build or IDE. Please add the 'micronaut-inject-java' annotation processor to your test processor path (for Java this is the testAnnotationProcessor scope, for Kotlin kaptTest and for Groovy testCompile). See the documentation for reference: https://micronaut-projects.github.io/micronaut-test/latest/guide/");
                }
                List features = invocation.getSpec().getFeatures();
                for (FeatureInfo feature : features) {
                    feature.setSkipped(true);
                }
            } else {
                List fields = spec.getAllFields();
                for (FieldInfo field : fields) {
                    if (!field.isShared() || field.getAnnotation(Inject.class) == null) continue;
                    this.applicationContext.inject(invocation.getSharedInstance());
                    break;
                }
            }
            this.beforeTestClass(this.buildContext(invocation, null));
            invocation.proceed();
        });
        spec.addCleanupSpecInterceptor(invocation -> {
            this.afterTestClass(this.buildContext(invocation, null));
            this.afterClass(invocation);
            invocation.proceed();
            this.singletonMocks.clear();
        });
        spec.addSetupInterceptor(invocation -> {
            Object instance = invocation.getInstance();
            Method method = (Method)invocation.getFeature().getFeatureMethod().getReflection();
            List<Annotation> propertyAnnotations = Arrays.asList(method.getAnnotationsByType(Property.class));
            this.beforeEach(invocation, instance, method, propertyAnnotations);
            for (Object e : this.creatableMocks) {
                this.mockUtil.attachMock(e, (Specification)instance);
            }
            for (Object e : this.singletonMocks) {
                this.mockUtil.attachMock(e, (Specification)instance);
            }
            try {
                this.beforeSetupTest(this.buildContext(invocation, null));
                invocation.proceed();
            }
            finally {
                this.afterSetupTest(this.buildContext(invocation, null));
            }
        });
        spec.addCleanupInterceptor(invocation -> {
            for (Object e : this.creatableMocks) {
                this.mockUtil.detachMock(e);
            }
            for (Object e : this.singletonMocks) {
                this.mockUtil.detachMock(e);
            }
            this.creatableMocks.clear();
            this.afterEach(invocation);
            try {
                this.beforeCleanupTest(this.buildContext(invocation, null));
                invocation.proceed();
            }
            finally {
                this.afterCleanupTest(this.buildContext(invocation, null));
            }
        });
    }

    private MicronautTestValue buildValueObject(MicronautTest micronautTest) {
        if (micronautTest != null) {
            return new MicronautTestValue(micronautTest.application(), micronautTest.environments(), micronautTest.packages(), micronautTest.propertySources(), micronautTest.rollback(), micronautTest.transactional(), micronautTest.rebuildContext(), (Class[])micronautTest.contextBuilder(), micronautTest.transactionMode(), micronautTest.startApplication());
        }
        return null;
    }

    private TestContext buildContext(IMethodInvocation invocation, Throwable exception) {
        return new TestContext(this.applicationContext, (Class)Optional.ofNullable(invocation.getSpec()).map(NodeInfo::getReflection).orElse(null), (AnnotatedElement)Optional.ofNullable(invocation.getFeature()).map(FeatureInfo::getFeatureMethod).map(NodeInfo::getReflection).orElse(null), invocation.getInstance(), exception);
    }

    public void visitFeatureAnnotation(T annotation, FeatureInfo feature) {
        throw new InvalidSpecException("@%s may not be applied to feature methods").withArgs(new Object[]{annotation.annotationType().getSimpleName()});
    }

    public void visitFixtureAnnotation(T annotation, MethodInfo fixtureMethod) {
        throw new InvalidSpecException("@%s may not be applied to fixture methods").withArgs(new Object[]{annotation.annotationType().getSimpleName()});
    }

    public void visitFieldAnnotation(T annotation, FieldInfo field) {
        throw new InvalidSpecException("@%s may not be applied to fields").withArgs(new Object[]{annotation.annotationType().getSimpleName()});
    }

    public void visitSpec(SpecInfo spec) {
    }

    protected void resolveTestProperties(IMethodInvocation context, MicronautTestValue testAnnotationValue, Map<String, Object> testProperties) {
        Map properties;
        Object sharedInstance = context.getSharedInstance();
        if (sharedInstance instanceof TestPropertyProvider && CollectionUtils.isNotEmpty((Map)(properties = ((TestPropertyProvider)sharedInstance).getProperties()))) {
            testProperties.putAll(properties);
        }
    }

    protected void startApplicationContext() {
        this.applicationContext.registerSingleton(event -> {
            Object bean = event.getBean();
            if (this.mockUtil.isMock(bean)) {
                if (event.getBeanDefinition().isSingleton()) {
                    this.singletonMocks.add(bean);
                } else {
                    this.creatableMocks.add(bean);
                }
            }
            return bean;
        });
        super.startApplicationContext();
    }

    protected void alignMocks(IMethodInvocation context, Object instance) {
        for (MethodInjectionPoint injectedMethod : this.specDefinition.getInjectedMethods()) {
            Object interceptedTarget;
            FieldInfo fieldInfo;
            Object fieldInstance;
            Optional<FieldInfo> fld;
            Argument[] args = injectedMethod.getArguments();
            if (args.length != 1 || !(fld = context.getSpec().getAllFields().stream().filter(f -> f.getName().equals(args[0].getName())).findFirst()).isPresent() || !((fieldInstance = (fieldInfo = fld.get()).readValue(instance)) instanceof InterceptedProxy) || !this.mockUtil.isMock(interceptedTarget = ((InterceptedProxy)fieldInstance).interceptedTarget())) continue;
            fieldInfo.writeValue(instance, interceptedTarget);
        }
    }
}

