/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.buildtools;

import io.micronaut.testresources.buildtools.ServerFactory;
import io.micronaut.testresources.buildtools.ServerSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    public static final String PROPERTIES_FILE_NAME = "test-resources.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ServerUtils.class.getName());
    private static final int STARTUP_TIME_WAIT_MS = 200;
    private static final String SERVER_URI = "server.uri";
    private static final String SERVER_ACCESS_TOKEN = "server.access.token";
    private static final String SERVER_CLIENT_READ_TIMEOUT = "server.client.read.timeout";
    private static final String SERVER_ENTRY_POINT = "io.micronaut.testresources.server.Application";
    private static final String MICRONAUT_SERVER_PORT = "micronaut.server.port";
    private static final String JMX_SYSTEM_PROPERTY = "com.sun.management.jmxremote";

    public static void writeServerSettings(Path destinationDirectory, ServerSettings settings) throws IOException {
        Files.createDirectories(destinationDirectory, new FileAttribute[0]);
        Path propertiesFile = destinationDirectory.resolve(PROPERTIES_FILE_NAME);
        try (PrintWriter prn = new PrintWriter(Files.newOutputStream(propertiesFile, new OpenOption[0]));){
            prn.println("server.uri=http\\://localhost\\:" + settings.getPort());
            settings.getAccessToken().ifPresent(token -> prn.println("server.access.token=" + token));
            settings.getClientTimeout().ifPresent(timeout -> prn.println("server.client.read.timeout=" + timeout));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ServerSettings> readServerSettings(Path settingsDirectory) {
        Path propertiesFile = settingsDirectory.resolve(PROPERTIES_FILE_NAME);
        if (!Files.exists(propertiesFile, new LinkOption[0])) return Optional.empty();
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(propertiesFile, new OpenOption[0]);){
            props.load(in);
            Optional<ServerSettings> optional = Optional.of(new ServerSettings(new URI(props.getProperty(SERVER_URI)).getPort(), props.getProperty(SERVER_ACCESS_TOKEN), Optional.ofNullable(props.getProperty(SERVER_CLIENT_READ_TIMEOUT)).map(Integer::parseInt).orElse(null)));
            return optional;
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Unable to read properties file", e);
        }
    }

    public static boolean isServerStarted(int port) {
        try {
            Socket socket = new Socket("localhost", port);
            socket.close();
            LOGGER.info("Test resources service already started on port {}", (Object)port);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static ServerSettings startOrConnectToExistingServer(Integer explicitPort, Path portFilePath, Path serverSettingsDirectory, String accessToken, Collection<File> serverClasspath, Integer clientTimeoutMs, ServerFactory serverFactory) throws IOException {
        Optional<ServerSettings> maybeServerSettings = ServerUtils.readServerSettings(serverSettingsDirectory);
        if (maybeServerSettings.isPresent()) {
            LOGGER.info("Server settings found in {}", (Object)serverSettingsDirectory);
            ServerSettings serverSettings = maybeServerSettings.get();
            if (explicitPort != null && ServerUtils.isServerStarted(explicitPort)) {
                if (serverSettings.getPort() == explicitPort.intValue()) {
                    return serverSettings;
                }
                throw new IllegalStateException("Server already started on port " + explicitPort + " but settings file says it should be on port " + serverSettings.getPort());
            }
            if (ServerUtils.isServerStarted(serverSettings.getPort())) {
                return serverSettings;
            }
        }
        if (Files.exists(portFilePath, new LinkOption[0])) {
            Files.delete(portFilePath);
        }
        Files.createDirectories(portFilePath.getParent(), new FileAttribute[0]);
        ServerUtils.startAndWait(serverFactory, explicitPort, portFilePath, accessToken, serverClasspath);
        int port = explicitPort == null ? Integer.parseInt(Files.readAllLines(portFilePath).get(0)) : explicitPort;
        ServerSettings settings = new ServerSettings(port, accessToken, clientTimeoutMs);
        ServerUtils.writeServerSettings(serverSettingsDirectory, settings);
        return settings;
    }

    public static void stopServer(Path serverSettingsDirectory) throws IOException {
        Optional<ServerSettings> maybeServerSettings = ServerUtils.readServerSettings(serverSettingsDirectory);
        if (maybeServerSettings.isPresent()) {
            ServerSettings serverSettings = maybeServerSettings.get();
            URL url = new URL("http://localhost:" + serverSettings.getPort() + "/stop");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            serverSettings.getAccessToken().ifPresent(token -> conn.setRequestProperty("Access-Token", (String)token));
            try (InputStream is = conn.getInputStream();){
                is.read();
            }
            Files.delete(serverSettingsDirectory.resolve(PROPERTIES_FILE_NAME));
        }
    }

    public static Path getDefaultSharedSettingsPath() {
        return Paths.get(System.getProperty("user.home"), ".micronaut/test-resources");
    }

    private static void startAndWait(ServerFactory serverFactory, final Integer explicitPort, final Path portFilePath, final String accessToken, final Collection<File> serverClasspath) throws IOException {
        serverFactory.startServer(new ProcessParameters(){

            @Override
            public String getMainClass() {
                return ServerUtils.SERVER_ENTRY_POINT;
            }

            @Override
            public Map<String, String> getSystemProperties() {
                HashMap<String, String> systemProperties = new HashMap<String, String>();
                systemProperties.put(ServerUtils.JMX_SYSTEM_PROPERTY, null);
                if (explicitPort != null) {
                    systemProperties.put(ServerUtils.MICRONAUT_SERVER_PORT, String.valueOf(explicitPort));
                }
                if (accessToken != null) {
                    systemProperties.put(ServerUtils.SERVER_ACCESS_TOKEN, accessToken);
                }
                return systemProperties;
            }

            @Override
            public List<File> getClasspath() {
                return Collections.unmodifiableList(new ArrayList(serverClasspath));
            }

            @Override
            public List<String> getArguments() {
                if (explicitPort == null) {
                    return Collections.singletonList("--port-file=" + portFilePath.toAbsolutePath());
                }
                return Collections.emptyList();
            }

            @Override
            public List<String> getJvmArguments() {
                return Collections.unmodifiableList(Arrays.asList("-XX:+TieredCompilation", "-XX:TieredStopAtLevel=1"));
            }
        });
        while (!Files.exists(portFilePath, new LinkOption[0])) {
            try {
                serverFactory.waitFor(Duration.of(200L, ChronoUnit.MILLIS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface ProcessParameters {
        public String getMainClass();

        public Map<String, String> getSystemProperties();

        public List<File> getClasspath();

        public List<String> getArguments();

        public List<String> getJvmArguments();
    }
}

