/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.buildtools;

import io.micronaut.testresources.buildtools.ClassDataSharingException;
import io.micronaut.testresources.buildtools.ServerFactory;
import io.micronaut.testresources.buildtools.ServerSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    public static final String PROPERTIES_FILE_NAME = "test-resources.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ServerUtils.class.getName());
    private static final int STARTUP_TIME_WAIT_MS = 200;
    private static final int MAX_READS = 10;
    private static final String SERVER_URI = "server.uri";
    private static final String SERVER_ACCESS_TOKEN_MICRONAUT_PROPERTY = "server.access-token";
    private static final String SERVER_ACCESS_TOKEN = "server.access.token";
    private static final String SERVER_CLIENT_READ_TIMEOUT = "server.client.read.timeout";
    private static final String SERVER_ENTRY_POINT = "io.micronaut.testresources.server.TestResourcesService";
    private static final String MICRONAUT_SERVER_PORT = "micronaut.server.port";
    private static final String JMX_SYSTEM_PROPERTY = "com.sun.management.jmxremote";
    private static final String CDS_HASH = "cds.bin";
    private static final String CDS_FILE = "cds.jsa";
    private static final String CDS_CLASS_LST = "cds.classlist";
    private static final String FLAT_JAR = "flat.jar";

    public static void writeServerSettings(Path destinationDirectory, ServerSettings settings) throws IOException {
        Files.createDirectories(destinationDirectory, new FileAttribute[0]);
        Path propertiesFile = destinationDirectory.resolve(PROPERTIES_FILE_NAME);
        try (PrintWriter prn = new PrintWriter(Files.newOutputStream(propertiesFile, new OpenOption[0]));){
            prn.println("server.uri=http\\://localhost\\:" + settings.getPort());
            settings.getAccessToken().ifPresent(token -> prn.println("server.access.token=" + token));
            settings.getClientTimeout().ifPresent(timeout -> prn.println("server.client.read.timeout=" + timeout));
        }
    }

    public static Optional<ServerSettings> readServerSettings(Path settingsDirectory) {
        Path propertiesFile = settingsDirectory.resolve(PROPERTIES_FILE_NAME);
        if (Files.exists(propertiesFile, new LinkOption[0])) {
            Optional<ServerSettings> optional;
            block9: {
                Properties props = new Properties();
                InputStream in = Files.newInputStream(propertiesFile, new OpenOption[0]);
                try {
                    props.load(in);
                    optional = Optional.of(new ServerSettings(new URI(props.getProperty(SERVER_URI)).getPort(), props.getProperty(SERVER_ACCESS_TOKEN), Optional.ofNullable(props.getProperty(SERVER_CLIENT_READ_TIMEOUT)).map(Integer::parseInt).orElse(null)));
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | URISyntaxException e) {
                        throw new RuntimeException("Unable to read properties file", e);
                    }
                }
                in.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    public static boolean isServerStarted(int port) {
        try {
            Socket socket = new Socket("localhost", port);
            socket.close();
            LOGGER.info("Test resources service already started on port {}", (Object)port);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static ServerSettings startOrConnectToExistingServer(Integer explicitPort, Path portFilePath, Path serverSettingsDirectory, String accessToken, Path cdsDirectory, Collection<File> serverClasspath, Integer clientTimeoutMs, ServerFactory serverFactory) throws IOException {
        int port;
        Optional<ServerSettings> maybeServerSettings = ServerUtils.readServerSettings(serverSettingsDirectory);
        if (maybeServerSettings.isPresent()) {
            LOGGER.info("Server settings found in {}", (Object)serverSettingsDirectory);
            ServerSettings serverSettings = maybeServerSettings.get();
            if (explicitPort != null && ServerUtils.isServerStarted(explicitPort)) {
                if (serverSettings.getPort() == explicitPort.intValue()) {
                    return serverSettings;
                }
                throw new IllegalStateException("Server already started on port " + explicitPort + " but settings file says it should be on port " + serverSettings.getPort());
            }
            if (ServerUtils.isServerStarted(serverSettings.getPort())) {
                return serverSettings;
            }
        }
        if (Files.exists(portFilePath, new LinkOption[0])) {
            Files.delete(portFilePath);
        }
        Files.createDirectories(portFilePath.getParent(), new FileAttribute[0]);
        ServerUtils.startAndWait(serverFactory, explicitPort, portFilePath, accessToken, serverClasspath, cdsDirectory);
        if (explicitPort == null) {
            List<String> lines = Files.readAllLines(portFilePath);
            int attempts = 1;
            while (lines.isEmpty()) {
                if (attempts == 10) {
                    throw new IllegalStateException("Unable to read port file " + portFilePath + ": file is empty");
                }
                try {
                    serverFactory.waitFor(Duration.of(200L, ChronoUnit.MILLIS));
                    lines = Files.readAllLines(portFilePath);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++attempts;
            }
            port = Integer.parseInt(lines.get(0));
        } else {
            port = explicitPort;
        }
        ServerSettings settings = new ServerSettings(port, accessToken, clientTimeoutMs);
        ServerUtils.writeServerSettings(serverSettingsDirectory, settings);
        return settings;
    }

    public static ServerSettings startOrConnectToExistingServer(Integer explicitPort, Path portFilePath, Path serverSettingsDirectory, String accessToken, Collection<File> serverClasspath, Integer clientTimeoutMs, ServerFactory serverFactory) throws IOException {
        return ServerUtils.startOrConnectToExistingServer(explicitPort, portFilePath, serverSettingsDirectory, accessToken, null, serverClasspath, clientTimeoutMs, serverFactory);
    }

    public static void stopServer(Path serverSettingsDirectory) throws IOException {
        Optional<ServerSettings> maybeServerSettings = ServerUtils.readServerSettings(serverSettingsDirectory);
        if (maybeServerSettings.isPresent()) {
            ServerSettings serverSettings = maybeServerSettings.get();
            URL url = new URL("http://localhost:" + serverSettings.getPort() + "/stop");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            serverSettings.getAccessToken().ifPresent(token -> conn.setRequestProperty("Access-Token", (String)token));
            try (InputStream is = conn.getInputStream();){
                is.read();
            }
            Files.delete(serverSettingsDirectory.resolve(PROPERTIES_FILE_NAME));
        }
    }

    public static Path getDefaultSharedSettingsPath() {
        return ServerUtils.getDefaultSharedSettingsPath(null);
    }

    public static Path getDefaultSharedSettingsPath(String namespace) {
        Object ns = namespace == null ? "test-resources" : "test-resources-" + namespace;
        return Paths.get(System.getProperty("user.home"), ".micronaut/" + (String)ns);
    }

    private static void startAndWait(ServerFactory serverFactory, Integer explicitPort, Path portFilePath, String accessToken, Collection<File> serverClasspath, Path cdsDirectory) throws IOException {
        ProcessParameters processParameters = ServerUtils.createProcessParameters(explicitPort, portFilePath, accessToken, serverClasspath, cdsDirectory);
        serverFactory.startServer(processParameters);
        if (processParameters.isCDSDumpInvocation()) {
            ServerUtils.startAndWait(serverFactory, explicitPort, portFilePath, accessToken, serverClasspath, cdsDirectory);
            return;
        }
        while (!Files.exists(portFilePath, new LinkOption[0])) {
            try {
                serverFactory.waitFor(Duration.of(200L, ChronoUnit.MILLIS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static ProcessParameters createProcessParameters(Integer explicitPort, Path portFilePath, String accessToken, Collection<File> serverClasspath, Path cdsDirectory) {
        return new DefaultProcessParameters(explicitPort, accessToken, cdsDirectory, serverClasspath, portFilePath);
    }

    public static interface ProcessParameters {
        public String getMainClass();

        public Map<String, String> getSystemProperties();

        public List<File> getClasspath();

        public List<String> getArguments();

        public List<String> getJvmArguments();

        default public boolean isCDSDumpInvocation() {
            return false;
        }
    }

    private static class DefaultProcessParameters
    implements ProcessParameters {
        private final Integer explicitPort;
        private final String accessToken;
        private final Path cdsDirectory;
        private final Collection<File> serverClasspath;
        private final Path portFilePath;
        private List<String> jvmArgs;
        private List<File> classpath;
        private File flatDirsJar;

        public DefaultProcessParameters(Integer explicitPort, String accessToken, Path cdsDirectory, Collection<File> serverClasspath, Path portFilePath) {
            this.explicitPort = explicitPort;
            this.accessToken = accessToken;
            this.cdsDirectory = cdsDirectory;
            this.serverClasspath = serverClasspath;
            this.portFilePath = portFilePath;
        }

        @Override
        public String getMainClass() {
            return ServerUtils.SERVER_ENTRY_POINT;
        }

        @Override
        public boolean isCDSDumpInvocation() {
            return this.getJvmArguments().stream().anyMatch(arg -> arg.contains("-Xshare:dump"));
        }

        @Override
        public Map<String, String> getSystemProperties() {
            HashMap<String, String> systemProperties = new HashMap<String, String>();
            systemProperties.put(ServerUtils.JMX_SYSTEM_PROPERTY, null);
            if (this.explicitPort != null) {
                systemProperties.put(ServerUtils.MICRONAUT_SERVER_PORT, String.valueOf(this.explicitPort));
            }
            if (this.accessToken != null) {
                systemProperties.put(ServerUtils.SERVER_ACCESS_TOKEN_MICRONAUT_PROPERTY, this.accessToken);
            }
            return systemProperties;
        }

        @Override
        public List<File> getClasspath() {
            if (this.classpath != null) {
                return this.classpath;
            }
            if (this.cdsDirectory != null && this.serverClasspath.stream().anyMatch(File::isDirectory)) {
                this.flatDirsJar = this.cdsDirectory.resolve(ServerUtils.FLAT_JAR).toFile();
                this.buildFlatJar();
                this.classpath = Stream.concat(Stream.of(this.flatDirsJar), this.serverClasspath.stream().filter(File::isFile)).collect(Collectors.toList());
            } else {
                this.classpath = Collections.unmodifiableList(new ArrayList<File>(this.serverClasspath));
            }
            return this.classpath;
        }

        private void buildFlatJar() {
            byte[] hash = DefaultProcessParameters.computeClasspathHash(this.serverClasspath.stream().filter(File::isDirectory).map(File::toPath).flatMap(path -> {
                Stream stream;
                block8: {
                    Stream<Path> files = Files.walk(path, new FileVisitOption[0]);
                    try {
                        stream = files.map(Path::toFile).collect(Collectors.toList()).stream();
                        if (files == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (files != null) {
                                try {
                                    files.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new ClassDataSharingException(e);
                        }
                    }
                    files.close();
                }
                return stream;
            }));
            File hashFile = new File(this.flatDirsJar.getParentFile(), this.flatDirsJar.getName() + ".bin");
            if (this.flatDirsJar.exists()) {
                try {
                    if (hashFile.exists() && Arrays.equals(Files.readAllBytes(hashFile.toPath()), hash)) {
                        return;
                    }
                }
                catch (IOException e) {
                    throw new ClassDataSharingException("Cannot read hash file", e);
                }
                DefaultProcessParameters.deleteCdsFiles(this.flatDirsJar);
            }
            this.createFlatJarArchiveFile(hash, hashFile);
        }

        private void createFlatJarArchiveFile(byte[] hash, File hashFile) {
            try (JarOutputStream jos = new JarOutputStream(Files.newOutputStream(this.flatDirsJar.toPath(), new OpenOption[0]));){
                Files.write(hashFile.toPath(), hash, new OpenOption[0]);
                HashSet<String> addedEntries = new HashSet<String>();
                for (File dir : this.serverClasspath) {
                    if (!dir.isDirectory()) continue;
                    Path rootDir = dir.toPath();
                    this.compressDirectory(jos, addedEntries, rootDir);
                }
            }
            catch (IOException e) {
                throw new ClassDataSharingException(e);
            }
        }

        private void compressDirectory(JarOutputStream jos, Set<String> addedEntries, Path rootDir) throws IOException {
            try (Stream<Path> stream = Files.walk(rootDir, new FileVisitOption[0]);){
                List allpaths = stream.collect(Collectors.toList());
                for (Path sourcePath : allpaths) {
                    if (sourcePath.equals(rootDir)) continue;
                    String zipFsPath = rootDir.relativize(sourcePath).toString();
                    JarEntry ze = new JarEntry(zipFsPath);
                    if (!Files.isRegularFile(sourcePath, new LinkOption[0]) || !addedEntries.add(zipFsPath)) continue;
                    jos.putNextEntry(ze);
                    Files.copy(sourcePath, jos);
                }
            }
        }

        @Override
        public List<String> getArguments() {
            if (this.explicitPort == null) {
                return Collections.singletonList("--port-file=" + this.portFilePath.toAbsolutePath());
            }
            return Collections.emptyList();
        }

        @Override
        public List<String> getJvmArguments() {
            if (this.jvmArgs != null) {
                return this.jvmArgs;
            }
            ArrayList<String> jvmArguments = new ArrayList<String>();
            jvmArguments.add("-XX:+TieredCompilation");
            jvmArguments.add("-XX:TieredStopAtLevel=1");
            if (this.cdsDirectory != null) {
                boolean useCDS;
                File cdsDir = this.cdsDirectory.toFile();
                boolean bl = useCDS = cdsDir.isDirectory() || cdsDir.mkdirs();
                if (useCDS) {
                    File cdsFile = new File(cdsDir, ServerUtils.CDS_FILE);
                    File cdsClassList = new File(cdsDir, ServerUtils.CDS_CLASS_LST);
                    File cdsHashFile = new File(cdsDir, ServerUtils.CDS_HASH);
                    this.configureCdsOptions(jvmArguments, cdsFile, cdsClassList, cdsHashFile);
                }
            }
            this.jvmArgs = Collections.unmodifiableList(jvmArguments);
            return this.jvmArgs;
        }

        private void configureCdsOptions(List<String> jvmArguments, File cdsFile, File cdsClassList, File cdsHashFile) {
            if (cdsClassList.exists()) {
                try {
                    byte[] actualHash = DefaultProcessParameters.computeClasspathHash(this.getClasspath().stream());
                    if (cdsHashFile.exists()) {
                        byte[] cdsHash = Files.readAllBytes(cdsHashFile.toPath());
                        if (!Arrays.equals(actualHash, cdsHash)) {
                            DefaultProcessParameters.deleteCdsFiles(cdsFile, cdsClassList, cdsHashFile);
                        }
                    } else {
                        Files.write(cdsHashFile.toPath(), actualHash, new OpenOption[0]);
                    }
                }
                catch (IOException e) {
                    DefaultProcessParameters.deleteCdsFiles(cdsFile, cdsClassList, cdsHashFile);
                }
            }
            if (cdsClassList.exists()) {
                if (!cdsFile.exists()) {
                    DefaultProcessParameters.configureCdsDump(jvmArguments, cdsFile, cdsClassList);
                } else {
                    jvmArguments.add("-XX:SharedArchiveFile=" + cdsFile);
                }
            } else {
                DefaultProcessParameters.configureExportCdsClassList(jvmArguments, cdsClassList);
            }
        }

        private static void deleteCdsFiles(File ... cdsFiles) {
            for (File cdsFile : cdsFiles) {
                try {
                    Files.deleteIfExists(cdsFile.toPath());
                }
                catch (IOException e) {
                    throw new ClassDataSharingException(e);
                }
            }
        }

        private static void configureExportCdsClassList(List<String> jvmArguments, File cdsClassList) {
            jvmArguments.add("-Xshare:off");
            jvmArguments.add("-XX:DumpLoadedClassList=" + cdsClassList);
        }

        private static void configureCdsDump(List<String> jvmArguments, File cdsFile, File cdsClassList) {
            try {
                Path cdsListPath = cdsClassList.toPath();
                ArrayList<String> fileContent = new ArrayList<String>(Files.readAllLines(cdsListPath, StandardCharsets.UTF_8));
                fileContent.removeIf(content -> content.contains("SingleThreadedBufferingProcessor") || content.contains("org/testcontainers") || content.contains("org/graalvm") || content.contains("io/netty/handler") || content.contains("jdk/proxy"));
                Files.write(cdsListPath, fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            jvmArguments.add("-Xshare:dump");
            jvmArguments.add("-XX:SharedClassListFile=" + cdsClassList);
            jvmArguments.add("-XX:SharedArchiveFile=" + cdsFile);
        }

        private static byte[] computeClasspathHash(Stream<File> files) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA1");
                files.flatMap(fileOrDir -> {
                    Stream stream;
                    block8: {
                        Stream<Path> s = Files.walk(fileOrDir.toPath(), new FileVisitOption[0]);
                        try {
                            stream = s.map(p -> {
                                File file = p.toFile();
                                return file.getAbsolutePath() + ":" + file.length() + ":" + file.lastModified();
                            }).collect(Collectors.toList()).stream();
                            if (s == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (s != null) {
                                    try {
                                        s.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                return Stream.empty();
                            }
                        }
                        s.close();
                    }
                    return stream;
                }).forEachOrdered(line -> digest.update(line.getBytes(StandardCharsets.UTF_8)));
                return digest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                return new byte[0];
            }
        }
    }
}

