/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.client;

import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.testresources.client.DefaultTestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClient;
import io.micronaut.testresources.client.TestResourcesException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Properties;

public final class TestResourcesClientFactory {
    private TestResourcesClientFactory() {
    }

    static TestResourcesClient configuredAt(URL configFile) {
        Properties props = new Properties();
        try (InputStream input = configFile.openStream();){
            props.load(input);
        }
        catch (IOException e) {
            throw new TestResourcesException(e);
        }
        try {
            String serverUri = props.getProperty("server.uri");
            String accessToken = props.getProperty("server.access.token");
            int clientReadTimeout = Integer.parseInt(props.getProperty("server.client.read.timeout", "60"));
            DefaultHttpClientConfiguration config = new DefaultHttpClientConfiguration();
            config.setReadTimeout(Duration.of(clientReadTimeout, ChronoUnit.SECONDS));
            HttpClient client = HttpClient.create((URL)new URL(serverUri), (HttpClientConfiguration)config);
            return new DefaultTestResourcesClient(client, accessToken);
        }
        catch (MalformedURLException e) {
            throw new TestResourcesException(e);
        }
    }
}

