/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.client;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.testresources.client.TestResourcesClient;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultTestResourcesClient
implements TestResourcesClient {
    public static final String ACCESS_TOKEN = "Access-Token";
    private static final URI RESOLVABLE_PROPERTIES_URI = UriBuilder.of((CharSequence)"/").path("/list").build();
    private static final URI REQUIRED_PROPERTIES_URI = UriBuilder.of((CharSequence)"/").path("/requirements/expr").build();
    private static final URI REQUIRED_PROPERTY_ENTRIES_URI = UriBuilder.of((CharSequence)"/").path("/requirements/entries").build();
    private static final URI CLOSE_ALL_URI = UriBuilder.of((CharSequence)"/").path("/close/all").build();
    private static final URI CLOSE_URI = UriBuilder.of((CharSequence)"/").path("/close").build();
    private static final URI RESOLVE_URI = UriBuilder.of((CharSequence)"/").path("/resolve").build();
    private final BlockingHttpClient client;
    private final String accessToken;

    public DefaultTestResourcesClient(HttpClient client, String accessToken) {
        this.client = client.toBlocking();
        this.accessToken = accessToken;
    }

    @Override
    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        properties.put("propertyEntries", propertyEntries);
        properties.put("testResourcesConfig", testResourcesConfig);
        MutableHttpRequest req = this.configure(HttpRequest.POST((URI)RESOLVABLE_PROPERTIES_URI, properties));
        return (List)this.client.retrieve(req, List.class);
    }

    @Override
    public Optional<String> resolve(String name, Map<String, Object> properties, Map<String, Object> testResourcesConfiguration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("properties", properties);
        params.put("testResourcesConfig", testResourcesConfiguration);
        MutableHttpRequest req = this.configure(HttpRequest.POST((URI)RESOLVE_URI, params));
        return Optional.ofNullable(this.client.retrieve(req));
    }

    @Override
    public List<String> getRequiredProperties(String expression) {
        return this.doGet(REQUIRED_PROPERTIES_URI, List.class, expression);
    }

    @Override
    public List<String> getRequiredPropertyEntries() {
        return this.doGet(REQUIRED_PROPERTY_ENTRIES_URI, List.class, new String[0]);
    }

    @Override
    public void closeAll() {
        this.doGet(CLOSE_ALL_URI, String.class, new String[0]);
    }

    @Override
    public void closeScope(String id) {
        this.doGet(CLOSE_URI, String.class, id);
    }

    private <T> T doGet(URI uri, Class<T> clazz, String ... pathElements) {
        UriBuilder builder = UriBuilder.of((URI)uri);
        for (String param : pathElements) {
            builder = builder.path(param);
        }
        MutableHttpRequest<T> req = this.configure(HttpRequest.GET((URI)builder.build()));
        return (T)this.client.retrieve(req, clazz);
    }

    private <T> MutableHttpRequest<T> configure(MutableHttpRequest<T> request) {
        MutableHttpRequest result = request.header((CharSequence)"User-Agent", (CharSequence)"Micronaut HTTP Client").header((CharSequence)"Accept", (CharSequence)"application/json");
        if (this.accessToken != null) {
            result = result.header((CharSequence)ACCESS_TOKEN, (CharSequence)this.accessToken);
        }
        return result;
    }
}

