/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.client;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.testresources.client.ConfigFinder;
import io.micronaut.testresources.client.TestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClientFactory;
import io.micronaut.testresources.core.LazyTestResourcesPropertySourceLoader;
import io.micronaut.testresources.core.PropertyExpressionProducer;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

public class TestResourcesClientPropertySourceLoader
extends LazyTestResourcesPropertySourceLoader {
    public TestResourcesClientPropertySourceLoader() {
        super((PropertyExpressionProducer)new ClientTestResourcesResolver());
    }

    private static class ClientTestResourcesResolver
    implements PropertyExpressionProducer {
        private final ReentrantLock lock = new ReentrantLock();
        private TestResourcesClient client;

        private ClientTestResourcesResolver() {
        }

        public List<String> getPropertyEntries() {
            return this.findClient(null).map(TestResourcesClient::getRequiredPropertyEntries).orElse(Collections.emptyList());
        }

        public List<String> produceKeys(ResourceLoader resourceLoader, Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
            return this.findClient(resourceLoader).map(client -> client.getResolvableProperties(propertyEntries, testResourcesConfig)).orElse(Collections.emptyList());
        }

        private Optional<TestResourcesClient> findClient(ResourceLoader resourceLoader) {
            this.lock.lock();
            try {
                if (this.client == null) {
                    Optional<URL> config = ConfigFinder.findConfiguration(resourceLoader);
                    config.ifPresent(url -> {
                        this.client = TestResourcesClientFactory.configuredAt(url);
                    });
                }
                Optional<TestResourcesClient> optional = Optional.ofNullable(this.client);
                return optional;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

