/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.client;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyExpressionResolver;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.testresources.client.ConfigFinder;
import io.micronaut.testresources.client.TestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClientFactory;
import io.micronaut.testresources.core.LazyTestResourcesExpressionResolver;
import io.micronaut.testresources.core.PropertyResolverSupport;
import io.micronaut.testresources.core.TestResourcesResolver;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResourcesClientPropertyExpressionResolver
extends LazyTestResourcesExpressionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestResourcesClientPropertyExpressionResolver.class);

    public TestResourcesClientPropertyExpressionResolver() {
        super((PropertyExpressionResolver)new DelegateResolver());
    }

    private static TestResourcesClient createClient(Environment env) {
        Optional<URL> config = ConfigFinder.findConfiguration((ResourceLoader)env);
        if (config.isPresent()) {
            return config.map(TestResourcesClientFactory::configuredAt).get();
        }
        return TestResourcesClientFactory.fromSystemProperties().orElse(NoOpClient.INSTANCE);
    }

    private static class DelegateResolver
    implements PropertyExpressionResolver,
    AutoCloseable {
        private final Map<Environment, TestResourcesClient> clients = new ConcurrentHashMap<Environment, TestResourcesClient>();

        private DelegateResolver() {
        }

        public <T> Optional<T> resolve(PropertyResolver propertyResolver, ConversionService<?> conversionService, String expression, Class<T> requiredType) {
            if (propertyResolver instanceof Environment) {
                Map properties;
                Map props;
                TestResourcesClient client = this.clients.computeIfAbsent((Environment)propertyResolver, x$0 -> TestResourcesClientPropertyExpressionResolver.createClient(x$0));
                Optional<String> resolved = DelegateResolver.callClient(expression, client, props = PropertyResolverSupport.resolveRequiredProperties((String)expression, (PropertyResolver)propertyResolver, (TestResourcesResolver)client), properties = propertyResolver.getProperties("test-resources"));
                if (resolved.isPresent()) {
                    String resolvedValue = resolved.get();
                    LOGGER.debug("Resolved expression '{}' to '{}'", (Object)expression, (Object)resolvedValue);
                    return conversionService.convert((Object)resolvedValue, requiredType);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Test resources cannot resolve expression '{}'", (Object)expression);
                }
            }
            return Optional.empty();
        }

        private static Optional<String> callClient(String expression, TestResourcesClient client, Map<String, Object> props, Map<String, Object> properties) {
            try {
                return client.resolve(expression, props, properties);
            }
            catch (HttpClientResponseException ex) {
                LOGGER.debug("Test resources client failed to resolve expression '{}'", (Object)expression, (Object)ex);
                return Optional.empty();
            }
        }

        @Override
        public void close() throws Exception {
            for (TestResourcesClient client : this.clients.values()) {
                client.closeAll();
            }
        }
    }

    private static class NoOpClient
    implements TestResourcesClient {
        static final TestResourcesClient INSTANCE = new NoOpClient();

        private NoOpClient() {
        }

        @Override
        public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
            return Collections.emptyList();
        }

        @Override
        public Optional<String> resolve(String name, Map<String, Object> properties, Map<String, Object> testResourcesConfiguration) {
            return Optional.empty();
        }

        @Override
        public List<String> getRequiredProperties(String expression) {
            return Collections.emptyList();
        }

        @Override
        public List<String> getRequiredPropertyEntries() {
            return Collections.emptyList();
        }

        @Override
        public void closeAll() {
        }

        @Override
        public void closeScope(String id) {
        }
    }
}

