/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.client;

import io.micronaut.context.ApplicationContext;
import io.micronaut.testresources.client.ConfigFinder;
import io.micronaut.testresources.client.DefaultTestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClientPropertySourceLoader;
import io.micronaut.testresources.client.TestResourcesException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;

public final class TestResourcesClientFactory {
    private static final String DEFAULT_TIMEOUT_SECONDS = "60";
    private static WeakReference<TestResourcesClient> cachedClient;

    private TestResourcesClientFactory() {
    }

    public static TestResourcesClient configuredAt(URL configFile) {
        Properties props = new Properties();
        try (InputStream input = configFile.openStream();){
            props.load(input);
        }
        catch (IOException e) {
            throw new TestResourcesException(e);
        }
        String serverUri = props.getProperty("server.uri");
        String accessToken = props.getProperty("server.access.token");
        int clientReadTimeout = Integer.parseInt(props.getProperty("server.client.read.timeout", DEFAULT_TIMEOUT_SECONDS));
        return new DefaultTestResourcesClient(serverUri, accessToken, clientReadTimeout);
    }

    public static Optional<TestResourcesClient> fromSystemProperties() {
        TestResourcesClient client;
        TestResourcesClient testResourcesClient = client = cachedClient != null ? (TestResourcesClient)cachedClient.get() : null;
        if (client != null) {
            return Optional.of(client);
        }
        String serverUri = System.getProperty(ConfigFinder.systemPropertyNameOf("server.uri"));
        if (serverUri != null) {
            String accessToken = System.getProperty(ConfigFinder.systemPropertyNameOf("server.access.token"));
            String clientTimeoutString = System.getProperty(ConfigFinder.systemPropertyNameOf("server.client.read.timeout"), DEFAULT_TIMEOUT_SECONDS);
            int clientReadTimeout = Integer.parseInt(clientTimeoutString);
            client = new DefaultTestResourcesClient(serverUri, accessToken, clientReadTimeout);
            cachedClient = new WeakReference<TestResourcesClient>(client);
            return Optional.of(client);
        }
        return Optional.empty();
    }

    public static TestResourcesClient extractFrom(ApplicationContext context) {
        return context.getEnvironment().getPropertySourceLoaders().stream().filter(TestResourcesClientPropertySourceLoader.class::isInstance).map(TestResourcesClientPropertySourceLoader.class::cast).map(TestResourcesClientPropertySourceLoader::getClient).findFirst().orElse(Optional.empty()).orElse(null);
    }
}

