/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.client;

import io.micronaut.context.ApplicationContext;
import io.micronaut.testresources.client.ConfigFinder;
import io.micronaut.testresources.client.DefaultTestResourcesClient;
import io.micronaut.testresources.client.NoOpClient;
import io.micronaut.testresources.client.TestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClientPropertySourceLoader;
import io.micronaut.testresources.client.TestResourcesException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.Properties;

public final class TestResourcesClientFactory {
    private static final String DEFAULT_TIMEOUT_SECONDS = "60";
    private static final String TEST_RESOURCES_PROPERTIES = "test-resources.properties";
    private static final String DEFAULT_MICRONAUT_DIR = ".micronaut/test-resources/";
    private static final String DEFAULT_PROPERTIES_RELATIVE_PATH = ".micronaut/test-resources/test-resources.properties";
    private static final String TEST_RESOURCES_NAMESPACE = "TEST_RESOURCES_NAMESPACE";
    private static final String NAMESPACE_PREFIX = ".micronaut/test-resources-";
    private static WeakReference<TestResourcesClient> cachedClient;

    private TestResourcesClientFactory() {
    }

    public static Optional<TestResourcesClient> findByConvention() {
        return TestResourcesClientFactory.fromSystemProperties().or(() -> TestResourcesClientFactory.fromFileSystem(Paths.get(DEFAULT_PROPERTIES_RELATIVE_PATH, new String[0]))).or(() -> {
            Path homedir = Paths.get(System.getProperty("user.home"), new String[0]);
            String namespace = System.getenv(TEST_RESOURCES_NAMESPACE);
            if (namespace != null) {
                return TestResourcesClientFactory.fromFileSystem(homedir.resolve(NAMESPACE_PREFIX + namespace + "/test-resources.properties"));
            }
            return TestResourcesClientFactory.fromFileSystem(homedir.resolve(DEFAULT_PROPERTIES_RELATIVE_PATH));
        });
    }

    public static Optional<TestResourcesClient> fromFileSystem(Path location) {
        if (Files.exists(location, new LinkOption[0]) && location.getFileName().endsWith(TEST_RESOURCES_PROPERTIES)) {
            Properties props = new Properties();
            try (InputStream input = Files.newInputStream(location, StandardOpenOption.READ);){
                props.load(input);
            }
            catch (IOException e) {
                throw new TestResourcesException(e);
            }
            String enabled = props.getProperty("enabled");
            if (enabled != null && !Boolean.parseBoolean(enabled)) {
                return Optional.of(NoOpClient.INSTANCE);
            }
            String serverUri = props.getProperty("server.uri");
            String accessToken = props.getProperty("server.access.token");
            int clientReadTimeout = Integer.parseInt(props.getProperty("server.client.read.timeout", DEFAULT_TIMEOUT_SECONDS));
            return Optional.of(new DefaultTestResourcesClient(serverUri, accessToken, clientReadTimeout));
        }
        return Optional.empty();
    }

    public static Optional<TestResourcesClient> fromSystemProperties() {
        TestResourcesClient client;
        TestResourcesClient testResourcesClient = client = cachedClient != null ? (TestResourcesClient)cachedClient.get() : null;
        if (client != null) {
            return Optional.of(client);
        }
        boolean enabled = Boolean.parseBoolean(System.getProperty(ConfigFinder.systemPropertyNameOf("enabled"), "true"));
        if (!enabled) {
            System.err.println("Test resources are disabled");
            return Optional.of(NoOpClient.INSTANCE);
        }
        String serverUri = System.getProperty(ConfigFinder.systemPropertyNameOf("server.uri"));
        if (serverUri != null) {
            String accessToken = System.getProperty(ConfigFinder.systemPropertyNameOf("server.access.token"));
            String clientTimeoutString = System.getProperty(ConfigFinder.systemPropertyNameOf("server.client.read.timeout"), DEFAULT_TIMEOUT_SECONDS);
            int clientReadTimeout = Integer.parseInt(clientTimeoutString);
            client = new DefaultTestResourcesClient(serverUri, accessToken, clientReadTimeout);
            cachedClient = new WeakReference<TestResourcesClient>(client);
            return Optional.of(client);
        }
        return Optional.empty();
    }

    public static TestResourcesClient extractFrom(ApplicationContext context) {
        return context.getEnvironment().getPropertySourceLoaders().stream().filter(TestResourcesClientPropertySourceLoader.class::isInstance).map(TestResourcesClientPropertySourceLoader.class::cast).map(TestResourcesClientPropertySourceLoader::getClient).findFirst().orElse(Optional.empty()).orElse(null);
    }
}

