/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonMapper;
import io.micronaut.testresources.client.SimpleJsonErrorModel;
import io.micronaut.testresources.client.TestResourcesClient;
import io.micronaut.testresources.client.TestResourcesException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

@Internal
public class DefaultTestResourcesClient
implements TestResourcesClient {
    public static final String ACCESS_TOKEN = "Access-Token";
    private static final String RESOLVABLE_PROPERTIES_URI = "/list";
    private static final String REQUIRED_PROPERTIES_URI = "/requirements/expr";
    private static final String REQUIRED_PROPERTY_ENTRIES_URI = "/requirements/entries";
    private static final String CLOSE_ALL_URI = "/close/all";
    private static final String CLOSE_URI = "/close";
    private static final String RESOLVE_URI = "/resolve";
    private static final Argument<List<String>> LIST_OF_STRING = Argument.LIST_OF_STRING;
    private static final Argument<String> STRING = Argument.STRING;
    private static final Argument<Boolean> BOOLEAN = Argument.BOOLEAN;
    private static final String INTERNAL_SERVER_ERROR = "Internal Server Error";
    private static final String INTERNAL_SERVER_ERROR_PREFIX = "Internal Server Error: ";
    private final JsonMapper jsonMapper;
    private final String baseUri;
    private final HttpClient client;
    private final String accessToken;
    private final Duration clientTimeout;

    public DefaultTestResourcesClient(String baseUri, String accessToken, int clientReadTimeout) {
        this.baseUri = baseUri;
        this.clientTimeout = Duration.ofSeconds(clientReadTimeout);
        this.client = HttpClient.newBuilder().connectTimeout(this.clientTimeout).build();
        this.accessToken = accessToken;
        this.jsonMapper = JsonMapper.createDefault();
    }

    @Override
    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        properties.put("propertyEntries", propertyEntries);
        properties.put("testResourcesConfig", testResourcesConfig);
        return this.request(RESOLVABLE_PROPERTIES_URI, LIST_OF_STRING, r -> this.POST((HttpRequest.Builder)r, properties));
    }

    @Override
    public Optional<String> resolve(String name, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("properties", properties);
        params.put("testResourcesConfig", testResourcesConfig);
        return Optional.ofNullable(this.request(RESOLVE_URI, STRING, r -> this.POST((HttpRequest.Builder)r, params)));
    }

    @Override
    public List<String> getRequiredProperties(String expression) {
        return this.request("/requirements/expr/" + expression, LIST_OF_STRING, this::GET);
    }

    @Override
    public List<String> getRequiredPropertyEntries() {
        return this.request(REQUIRED_PROPERTY_ENTRIES_URI, LIST_OF_STRING, this::GET);
    }

    @Override
    public boolean closeAll() {
        return this.request(CLOSE_ALL_URI, BOOLEAN, this::GET);
    }

    @Override
    public boolean closeScope(@Nullable String id) {
        return this.request("/close/" + id, BOOLEAN, this::GET);
    }

    private void POST(HttpRequest.Builder request, Object o) {
        request.POST(HttpRequest.BodyPublishers.ofByteArray(this.writeValueAsBytes(o)));
    }

    private void GET(HttpRequest.Builder request) {
        request.GET();
    }

    private <T> T request(String path, Argument<T> type, Consumer<? super HttpRequest.Builder> config) {
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(this.uri(path)).timeout(this.clientTimeout);
        request = request.header("User-Agent", "Micronaut Test Resources Client").header("Content-Type", "application/json").header("Accept", "application/json");
        if (this.accessToken != null) {
            request = request.header(ACCESS_TOKEN, this.accessToken);
        }
        config.accept(request);
        try {
            HttpResponse<String> response = this.client.send(request.build(), HttpResponse.BodyHandlers.ofString());
            String body = response.body();
            if (response.statusCode() == 200) {
                if (STRING.equalsType(type)) {
                    return (T)body;
                }
                return (T)this.jsonMapper.readValue(body, type);
            }
            if (response.statusCode() == 500) {
                return this.handleError((SimpleJsonErrorModel)this.jsonMapper.readValue(body, SimpleJsonErrorModel.class));
            }
            if (response.statusCode() == 404) {
                return null;
            }
            throw new TestResourcesException("Unexpected response code: " + response.statusCode() + " " + body);
        }
        catch (ConnectException e) {
            throw new TestResourcesException("Test resource service is not available at " + this.baseUri, e);
        }
        catch (IOException e) {
            throw new TestResourcesException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TestResourcesException(e);
        }
    }

    private <T> T handleError(SimpleJsonErrorModel model) {
        LinkedHashSet<String> allErrors = new LinkedHashSet<String>();
        this.collectErrors(model, allErrors);
        List errorList = allErrors.stream().toList();
        if (errorList.size() == 1) {
            throw new TestResourcesException((String)errorList.get(0));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Server failed with the following errors:\n");
        for (String error : errorList) {
            sb.append(" - ").append(error).append("\n");
        }
        throw new TestResourcesException(sb.toString());
    }

    private void collectErrors(SimpleJsonErrorModel model, LinkedHashSet<String> allErrors) {
        DefaultTestResourcesClient.sanitizeError(model.message()).ifPresent(allErrors::add);
        if (model.embedded() != null && model.embedded().errors() != null) {
            for (SimpleJsonErrorModel error : model.embedded().errors()) {
                this.collectErrors(error, allErrors);
            }
        }
    }

    private static Optional<String> sanitizeError(String message) {
        if (message.equals(INTERNAL_SERVER_ERROR)) {
            return Optional.empty();
        }
        if (message.startsWith(INTERNAL_SERVER_ERROR_PREFIX)) {
            return Optional.of(message.substring(INTERNAL_SERVER_ERROR_PREFIX.length()));
        }
        return Optional.of(message);
    }

    private URI uri(String path) {
        try {
            return new URI(this.baseUri + path);
        }
        catch (URISyntaxException e) {
            throw new TestResourcesException(e);
        }
    }

    private byte[] writeValueAsBytes(Object o) {
        try {
            return this.jsonMapper.writeValueAsBytes(o);
        }
        catch (IOException e) {
            throw new TestResourcesException(e);
        }
    }
}

