/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.controlpanel;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.testresources.core.TestResourcesResolver;
import io.micronaut.testresources.server.PropertyResolutionListener;
import jakarta.inject.Singleton;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
public class ControlPanelPropertyResolutionListener
implements PropertyResolutionListener {
    private final Map<String, Set<Resolution>> resolvedProperties = new HashMap<String, Set<Resolution>>();
    private final Map<String, Set<ResolutionError>> errors = new HashMap<String, Set<ResolutionError>>();

    public void resolved(String property, String resolvedValue, TestResourcesResolver resolver, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        Resolution resolution = new Resolution(property, resolvedValue, ControlPanelPropertyResolutionListener.asStringMap(properties), ControlPanelPropertyResolutionListener.asStringMap(testResourcesConfig));
        this.resolvedProperties.computeIfAbsent(resolver.getId(), k -> new HashSet()).add(resolution);
    }

    public void errored(String property, TestResourcesResolver resolver, Throwable exception) {
        ResolutionError error = ResolutionError.of(property, exception);
        this.errors.computeIfAbsent(resolver.getId(), k -> new HashSet()).add(error);
    }

    public List<Resolution> findByResolver(TestResourcesResolver resolver) {
        return this.findById(resolver.getId());
    }

    public List<Resolution> findById(String id) {
        return this.resolvedProperties.getOrDefault(id, Set.of()).stream().sorted(Comparator.comparing(Resolution::property)).toList();
    }

    public List<ResolutionError> findErrorsById(String id) {
        return this.errors.getOrDefault(id, Set.of()).stream().sorted(Comparator.comparing(ResolutionError::property)).toList();
    }

    private static Map<String, String> asStringMap(Map<String, Object> input) {
        return input.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue())));
    }

    @Introspected
    public record Resolution(String property, String resolvedValue, Map<String, String> properties, Map<String, String> testResourcesConfig) {
    }

    @Introspected
    public record ResolutionError(String property, String stackTrace) {
        public static ResolutionError of(String property, Throwable exception) {
            StringWriter stackTrace = new StringWriter();
            try (PrintWriter writer = new PrintWriter(stackTrace);){
                exception.printStackTrace(writer);
            }
            return new ResolutionError(property, stackTrace.toString());
        }
    }
}

