/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.controlpanel;

import com.github.dockerjava.api.model.Info;
import io.micronaut.controlpanel.core.AbstractControlPanel;
import io.micronaut.controlpanel.core.config.ControlPanelConfiguration;
import io.micronaut.testresources.controlpanel.DockerHealth;
import io.micronaut.testresources.controlpanel.Status;
import io.micronaut.testresources.controlpanel.TestResourcesContainer;
import io.micronaut.testresources.core.Scope;
import io.micronaut.testresources.testcontainers.DockerSupport;
import io.micronaut.testresources.testcontainers.TestContainers;
import jakarta.inject.Singleton;
import java.util.List;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

@Singleton
public class DockerHealthControlPanel
extends AbstractControlPanel<DockerHealth> {
    private static final String NAME = "docker";

    protected DockerHealthControlPanel() {
        super(NAME, DockerHealthControlPanel.createConfiguration());
    }

    private static ControlPanelConfiguration createConfiguration() {
        ControlPanelConfiguration controlPanelConfiguration = new ControlPanelConfiguration(NAME);
        controlPanelConfiguration.setTitle("Docker");
        controlPanelConfiguration.setIcon("fa-flask-vial");
        controlPanelConfiguration.setOrder(-1);
        return controlPanelConfiguration;
    }

    public String getBadge() {
        DockerHealth body = this.getBody();
        int inProgress = TestContainers.startingContainers().size() + TestContainers.pullingContainers().size();
        return String.valueOf(body.runningContainers() + inProgress);
    }

    public DockerHealth getBody() {
        boolean dockerAvailable = DockerSupport.isDockerAvailable();
        if (dockerAvailable) {
            DockerClientFactory factory = DockerClientFactory.instance();
            try {
                int runningContainers = TestContainers.listAll().values().stream().map(List::size).reduce(0, Integer::sum);
                List<TestResourcesContainer> containers = TestContainers.listAll().entrySet().stream().flatMap(entry -> {
                    Scope scope = (Scope)entry.getKey();
                    List values = (List)entry.getValue();
                    return values.stream().map(c -> new TestResourcesContainer(scope.toString(), c.getContainerId(), c.getContainerName(), DockerHealthControlPanel.networkOf(c), c.getDockerImageName()));
                }).toList();
                Info info = factory.getInfo();
                List starting = TestContainers.startingContainers();
                List pulling = TestContainers.pullingContainers();
                return new DockerHealth(Status.AVAILABLE, info, runningContainers, containers, pulling, starting);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DockerHealth(Status.UNAVAILABLE, null, 0, List.of(), List.of(), List.of());
    }

    private static String networkOf(GenericContainer<?> c) {
        Network network = c.getNetwork();
        return network == null ? "" : network.getId();
    }
}

