/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.controlpanel;

import io.micronaut.controlpanel.core.AbstractControlPanel;
import io.micronaut.controlpanel.core.ControlPanel;
import io.micronaut.controlpanel.core.config.ControlPanelConfiguration;
import io.micronaut.testresources.controlpanel.ControlPanelPropertyResolutionListener;
import io.micronaut.testresources.controlpanel.TestResourcesControlPanelBody;

public class TestResourcesControlPanel
extends AbstractControlPanel<TestResourcesControlPanelBody> {
    private final ControlPanelPropertyResolutionListener resolutionListener;
    private final String id;

    public TestResourcesControlPanel(String id, String name, ControlPanelPropertyResolutionListener resolutionListener) {
        super(id, TestResourcesControlPanel.createConfiguration(id, name));
        this.id = id;
        this.resolutionListener = resolutionListener;
    }

    public String getBadge() {
        return String.valueOf(this.resolutionListener.findById(this.id).size());
    }

    public int getErrorCount() {
        return this.resolutionListener.findErrorsById(this.id).size();
    }

    public TestResourcesControlPanelBody getBody() {
        return new TestResourcesControlPanelBody(this.resolutionListener.findById(this.id), this.resolutionListener.findErrorsById(this.id));
    }

    public ControlPanel.View getBodyView() {
        return new ControlPanel.View("/views/test-resources/body");
    }

    public ControlPanel.View getDetailedView() {
        return new ControlPanel.View("/views/test-resources/detail");
    }

    private static ControlPanelConfiguration createConfiguration(String id, String name) {
        ControlPanelConfiguration controlPanelConfiguration = new ControlPanelConfiguration(id);
        controlPanelConfiguration.setTitle(name);
        controlPanelConfiguration.setIcon("fa-flask-vial");
        return controlPanelConfiguration;
    }
}

