/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.controlpanel;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.RuntimeBeanDefinition;
import io.micronaut.context.annotation.Context;
import io.micronaut.controlpanel.core.ControlPanel;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.event.annotation.EventListener;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.testresources.controlpanel.ControlPanelPropertyResolutionListener;
import io.micronaut.testresources.controlpanel.TestResourcesControlPanel;
import io.micronaut.testresources.embedded.TestResourcesResolverLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
public class TestResourcesPanelRegistration {
    public static final Argument<ControlPanel> CONTROL_PANEL_ARGUMENT = Argument.of(ControlPanel.class, (Argument[])new Argument[]{Argument.ofTypeVariable(Object.class, (String)"E")});
    private static final Logger LOGGER = LoggerFactory.getLogger(TestResourcesPanelRegistration.class);

    public TestResourcesPanelRegistration(ApplicationContext beanContext, ControlPanelPropertyResolutionListener resolutionListener) {
        TestResourcesResolverLoader loader = TestResourcesResolverLoader.getInstance();
        loader.getResolvers().forEach(e -> beanContext.registerBeanDefinition(RuntimeBeanDefinition.builder(CONTROL_PANEL_ARGUMENT, () -> new TestResourcesControlPanel(e.getId(), e.getDisplayName(), resolutionListener)).singleton(true).qualifier(Qualifiers.byName((String)("testResources" + e.getId()))).build()));
    }

    @EventListener
    public void onStartup(ServerStartupEvent event) {
        EmbeddedServer server = event.getSource();
        int port = server.getPort();
        LOGGER.info("Test Resources control panel can be browsed at http://localhost:{}/control-panel", (Object)port);
    }
}

