/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.embedded;

import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.testresources.core.TestResourcesResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestResourcesResolverLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestResourcesResolverLoader.class);
    private final List<TestResourcesResolver> resolvers;

    public TestResourcesResolverLoader() {
        SoftServiceLoader loader = SoftServiceLoader.load(TestResourcesResolver.class);
        ArrayList values = new ArrayList();
        loader.collectAll(values);
        this.resolvers = OrderUtil.sort(values.stream()).collect(Collectors.toList());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loaded {} test resources resolvers: {}", (Object)this.resolvers.size(), (Object)this.resolvers.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining(", ")));
        }
    }

    public List<TestResourcesResolver> getResolvers() {
        return this.resolvers;
    }

    static TestResourcesResolverLoader getInstance() {
        return Initializer.INSTANCE;
    }

    private static class Initializer {
        private static final TestResourcesResolverLoader INSTANCE = new TestResourcesResolverLoader();

        private Initializer() {
        }
    }
}

